/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.reader;

import io.camunda.optimize.dto.optimize.query.processoverview.ProcessDigestResponseDto;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.service.db.repository.ProcessRepository;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessOverviewReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessOverviewReader.class);
    private final ProcessRepository processRepository;

    public ProcessOverviewReader(ProcessRepository processRepository) {
        this.processRepository = processRepository;
    }

    public Map<String, ProcessOverviewDto> getProcessOverviewsByKey(Set<String> processDefinitionKeys) {
        return this.processRepository.getProcessOverviewsByKey(processDefinitionKeys);
    }

    public Optional<ProcessOverviewDto> getProcessOverviewByKey(String processDefinitionKey) {
        Map<String, ProcessOverviewDto> goalsForProcessesByKey = this.getProcessOverviewsByKey(Collections.singleton(processDefinitionKey));
        return Optional.ofNullable(goalsForProcessesByKey.get(processDefinitionKey));
    }

    public Map<String, ProcessDigestResponseDto> getAllActiveProcessDigestsByKey() {
        return this.processRepository.getAllActiveProcessDigestsByKey();
    }

    public Map<String, ProcessOverviewDto> getProcessOverviewsWithPendingOwnershipData() {
        return this.processRepository.getProcessOverviewsWithPendingOwnershipData();
    }
}

