/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import io.camunda.optimize.dto.optimize.query.TerminatedUserSessionDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.writer.TerminatedUserSessionWriter;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class TerminatedUserSessionWriterOS
extends TerminatedUserSessionWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TerminatedUserSessionWriterOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final DateTimeFormatter dateTimeFormatter;

    public TerminatedUserSessionWriterOS(OptimizeOpenSearchClient osClient, DateTimeFormatter dateTimeFormatter) {
        this.osClient = osClient;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    protected void performWritingTerminatedUserSession(TerminatedUserSessionDto sessionDto) {
        IndexRequest.Builder request = new IndexRequest.Builder().index("terminated-user-session").id(sessionDto.getId()).document((Object)sessionDto).refresh(Refresh.True);
        this.osClient.index(request);
    }

    @Override
    protected void performDeleteTerminatedUserSessionOlderThan(OffsetDateTime timestamp) throws IOException {
        Query filterQuery = QueryDSL.lte((String)"terminationTimestamp", (Object)this.dateTimeFormatter.format(timestamp));
        this.osClient.deleteByQuery(filterQuery, true, new String[]{"terminated-user-session"});
    }
}

