/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import io.camunda.optimize.dto.optimize.query.sharing.DashboardShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ReportShareRestDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.writer.SharingWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class SharingWriterOS
implements SharingWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SharingWriterOS.class);
    private final OptimizeOpenSearchClient osClient;

    public SharingWriterOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public ReportShareRestDto saveReportShare(ReportShareRestDto createSharingDto) {
        LOG.debug("Writing new report share to OpenSearch");
        String id = IdGenerator.getNextId();
        createSharingDto.setId(id);
        IndexRequest.Builder indexRequestBuilder = new IndexRequest.Builder().index("report-share").id(createSharingDto.getId()).refresh(Refresh.True).document((Object)createSharingDto);
        IndexResponse indexResponse = this.osClient.index(indexRequestBuilder);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = "Could not write report share to OpenSearch.";
            LOG.error("Could not write report share to OpenSearch.");
            throw new OptimizeRuntimeException("Could not write report share to OpenSearch.");
        }
        LOG.debug("report share with id [{}] for resource [{}] has been created", (Object)id, (Object)createSharingDto.getReportId());
        return createSharingDto;
    }

    @Override
    public DashboardShareRestDto saveDashboardShare(DashboardShareRestDto createSharingDto) {
        LOG.debug("Writing new dashboard share to OpenSearch");
        String id = IdGenerator.getNextId();
        createSharingDto.setId(id);
        IndexRequest.Builder indexRequestBuilder = new IndexRequest.Builder().index("dashboard-share").id(createSharingDto.getId()).refresh(Refresh.True).document((Object)createSharingDto);
        IndexResponse indexResponse = this.osClient.index(indexRequestBuilder);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = "Could not write dashboard share to OpenSearch";
            LOG.error("Could not write dashboard share to OpenSearch");
            throw new OptimizeRuntimeException("Could not write dashboard share to OpenSearch");
        }
        LOG.debug("Dashboard share with id [{}] for resource [{}] has been created", (Object)id, (Object)createSharingDto.getDashboardId());
        return createSharingDto;
    }

    @Override
    public void updateDashboardShare(DashboardShareRestDto updatedShare) {
        String id = updatedShare.getId();
        IndexRequest.Builder indexRequestBuilder = new IndexRequest.Builder().index("dashboard-share").id(id).document((Object)updatedShare).refresh(Refresh.True);
        IndexResponse indexResponse = this.osClient.index(indexRequestBuilder);
        if (!indexResponse.result().equals((Object)Result.Created) && !indexResponse.result().equals((Object)Result.Updated)) {
            String message = String.format("Was not able to update dashboard share with id [%s] for resource [%s].", id, updatedShare.getDashboardId());
            LOG.error(message);
            throw new OptimizeRuntimeException(message);
        }
        LOG.debug("Dashboard share with id [{}] for resource [{}] has been updated", (Object)id, (Object)updatedShare.getDashboardId());
    }

    @Override
    public void deleteReportShare(String shareId) {
        LOG.debug("Deleting report share with id [{}]", (Object)shareId);
        DeleteResponse deleteResponse = this.osClient.delete("report-share", shareId);
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete report share with id [%s]. Report share does not exist. Maybe it was already deleted by someone else?", shareId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void deleteDashboardShare(String shareId) {
        LOG.debug("Deleting dashboard share with id [{}]", (Object)shareId);
        DeleteResponse deleteResponse = this.osClient.delete("dashboard-share", shareId);
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String errorMessage = String.format("Could not delete dashboard share with id [%s]. Dashboard share does not exist. Maybe it was already deleted by someone else?", shareId);
            LOG.error(errorMessage);
            throw new NotFoundException(errorMessage);
        }
    }
}

