/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.SettingsDto;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.schema.index.SettingsIndex;
import io.camunda.optimize.service.db.writer.SettingsWriter;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.HashSet;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class SettingWriterOS
implements SettingsWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SettingWriterOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ObjectMapper objectMapper;

    public SettingWriterOS(OptimizeOpenSearchClient osClient, ObjectMapper objectMapper) {
        this.osClient = osClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public void upsertSettings(SettingsDto settingsDto) {
        LOG.debug("Writing settings to OpenSearch");
        UpdateRequest.Builder<SettingsDto, Void> request = this.createSettingsUpsert(settingsDto);
        String errorMessage = "There were errors while writing settings to OpenSearch.";
        this.osClient.upsert(request, SettingsDto.class, e -> "There were errors while writing settings to OpenSearch.");
        LOG.debug("Finished updating Optimize Settings");
    }

    private UpdateRequest.Builder<SettingsDto, Void> createSettingsUpsert(SettingsDto settingsDto) {
        HashSet<String> fieldsToUpdate = new HashSet<String>();
        if (settingsDto.getSharingEnabled().isPresent()) {
            fieldsToUpdate.add(SettingsIndex.SHARING_ENABLED);
        }
        if (fieldsToUpdate.isEmpty()) {
            throw new BadRequestException("No settings can be updated, as no values are present!");
        }
        fieldsToUpdate.add(SettingsIndex.LAST_MODIFIED);
        Script updateScript = OpenSearchWriterUtil.createFieldUpdateScript(fieldsToUpdate, settingsDto, this.objectMapper);
        return new UpdateRequest.Builder().index("settings").id("1").upsert((Object)settingsDto).script(updateScript).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
    }
}

