/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.writer.AbstractProcessDefinitionWriterOS;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.writer.ProcessDefinitionWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessDefinitionWriterOS
extends AbstractProcessDefinitionWriterOS
implements ProcessDefinitionWriter {
    private static final Script MARK_AS_DELETED_SCRIPT = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("ctx._source.deleted = true", Collections.emptyMap());
    private static final Script MARK_AS_ONBOARDED_SCRIPT = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("ctx._source.onboarded = true", Collections.emptyMap());
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionWriterOS.class);
    private final ConfigurationService configurationService;

    public ProcessDefinitionWriterOS(OptimizeOpenSearchClient osClient, ObjectMapper objectMapper, ConfigurationService configurationService) {
        super(objectMapper, osClient);
        this.configurationService = configurationService;
    }

    @Override
    public void importProcessDefinitions(List<ProcessDefinitionOptimizeDto> procDefs) {
        LOG.debug("Writing [{}] process definitions to opensearch", (Object)procDefs.size());
        this.writeProcessDefinitionInformation(procDefs);
    }

    @Override
    public void markDefinitionAsDeleted(String definitionId) {
        LOG.debug("Marking process definition with ID {} as deleted", (Object)definitionId);
        UpdateRequest.Builder updateReqBuilder = new UpdateRequest.Builder().index("process-definition").id(definitionId).script(MARK_AS_DELETED_SCRIPT).retryOnConflict(Integer.valueOf(5));
        String errorMessage = String.format("There was a problem when trying to mark process definition with ID %s as deleted", definitionId);
        this.osClient.update(updateReqBuilder, errorMessage);
    }

    @Override
    public boolean markRedeployedDefinitionsAsDeleted(List<ProcessDefinitionOptimizeDto> importedDefinitions) {
        AtomicBoolean definitionsUpdated = new AtomicBoolean(false);
        Lists.partition(importedDefinitions, (int)100).forEach(partition -> {
            BoolQuery.Builder definitionsToDeleteQuery = new BoolQuery.Builder();
            partition.forEach(definition -> {
                BoolQuery.Builder matchingDefinitionQuery = new BoolQuery.Builder().must(QueryDSL.term((String)"key", (String)definition.getKey()), new Query[0]).must(QueryDSL.term((String)"version", (String)definition.getVersion()), new Query[0]).mustNot(QueryDSL.term((String)"id", (String)definition.getId()), new Query[0]);
                if (definition.getTenantId() != null) {
                    matchingDefinitionQuery.must(QueryDSL.term((String)"tenantId", (String)definition.getTenantId()), new Query[0]);
                } else {
                    matchingDefinitionQuery.mustNot(QueryDSL.exists((String)"tenantId"), new Query[0]);
                }
                definitionsToDeleteQuery.should(matchingDefinitionQuery.build().toQuery(), new Query[0]);
            });
            long deleted = this.osClient.updateByQuery("process-definition", definitionsToDeleteQuery.build().toQuery(), MARK_AS_DELETED_SCRIPT);
            if (deleted > 0L && !definitionsUpdated.get()) {
                definitionsUpdated.set(true);
            }
        });
        if (definitionsUpdated.get()) {
            LOG.debug("Marked old process definitions with new deployments as deleted");
        }
        return definitionsUpdated.get();
    }

    @Override
    public void markDefinitionKeysAsOnboarded(Set<String> definitionKeys) {
        this.osClient.updateByQuery("process-definition", new BoolQuery.Builder().must(QueryDSL.terms((String)"key", definitionKeys, FieldValue::of), new Query[0]).build().toQuery(), MARK_AS_ONBOARDED_SCRIPT);
    }

    @Override
    Script createUpdateScript(ProcessDefinitionOptimizeDto processDefinitionDto) {
        return OpenSearchWriterUtil.createFieldUpdateScript(FIELDS_TO_UPDATE, processDefinitionDto, this.objectMapper);
    }

    private void writeProcessDefinitionInformation(List<ProcessDefinitionOptimizeDto> procDefs) {
        String importItemName = "process definition information";
        LOG.debug("Writing [{}] {} to OpenSearch.", (Object)procDefs.size(), (Object)"process definition information");
        this.osClient.doImportBulkRequestWithList("process definition information", procDefs, this::addImportProcessDefinitionToRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached(), "process-definition");
    }
}

