/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.DecisionDefinitionOptimizeDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.writer.DecisionDefinitionXmlWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionDefinitionXmlWriterOS
implements DecisionDefinitionXmlWriter {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionDefinitionXmlWriterOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService indexNameService;
    private final ObjectMapper objectMapper;

    public DecisionDefinitionXmlWriterOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService, OptimizeIndexNameService indexNameService, ObjectMapper objectMapper) {
        this.osClient = osClient;
        this.configurationService = configurationService;
        this.indexNameService = indexNameService;
        this.objectMapper = objectMapper;
    }

    @Override
    public void importDecisionDefinitionXmls(List<DecisionDefinitionOptimizeDto> decisionDefinitions) {
        String importItemName = "decision definition XML information";
        LOG.debug("Writing [{}] {} to OS.", (Object)decisionDefinitions.size(), (Object)"decision definition XML information");
        this.osClient.doImportBulkRequestWithList("decision definition XML information", decisionDefinitions, this::addImportDecisionDefinitionXmlRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached());
    }

    private BulkOperation addImportDecisionDefinitionXmlRequest(DecisionDefinitionOptimizeDto decisionDefinitionDto) {
        Script script = OpenSearchWriterUtil.createFieldUpdateScript(FIELDS_TO_UPDATE, decisionDefinitionDto, this.objectMapper);
        return (BulkOperation)new BulkOperation.Builder().update(((UpdateOperation.Builder)((UpdateOperation.Builder)new UpdateOperation.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex("decision-definition"))).id(decisionDefinitionDto.getId())).script(script).upsert((Object)decisionDefinitionDto).retryOnConflict(Integer.valueOf(5)).build()).build();
    }
}

