/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.util;

import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.schema.index.AbstractInstanceIndex;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public final class DefinitionQueryUtilOS {
    private DefinitionQueryUtilOS() {
    }

    public static BoolQuery.Builder createDefinitionQuery(String definitionKey, List<String> definitionVersions, List<String> tenantIds, AbstractInstanceIndex type, UnaryOperator<String> getLatestVersionToKey) {
        BoolQuery.Builder queryBuilder = new BoolQuery.Builder();
        queryBuilder.must(DefinitionQueryUtilOS.createTenantIdQuery(type.getTenantIdFieldName(), tenantIds), new Query[0]);
        queryBuilder.must(QueryDSL.term((String)type.getDefinitionKeyFieldName(), (String)definitionKey), new Query[0]);
        if (DefinitionVersionHandlingUtil.isDefinitionVersionSetToLatest(definitionVersions)) {
            queryBuilder.must(QueryDSL.term((String)type.getDefinitionVersionFieldName(), (String)((String)getLatestVersionToKey.apply(definitionKey))), new Query[0]);
        } else if (!DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(definitionVersions)) {
            queryBuilder.must(QueryDSL.stringTerms((String)type.getDefinitionVersionFieldName(), definitionVersions), new Query[0]);
        } else if (definitionVersions.isEmpty()) {
            queryBuilder.mustNot(QueryDSL.matchAll(), new Query[0]);
        }
        return queryBuilder;
    }

    public static Query createTenantIdQuery(String tenantField, List<String> tenantIds) {
        Map<Boolean, List<String>> groupedByNullTenantIds = tenantIds.stream().collect(Collectors.groupingBy(Objects::isNull));
        boolean includeNotDefinedTenant = groupedByNullTenantIds.containsKey(true);
        List tenantIdTerms = groupedByNullTenantIds.getOrDefault(false, List.of());
        BoolQuery.Builder tenantQueryBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        if (!tenantIdTerms.isEmpty()) {
            tenantQueryBuilder.should(QueryDSL.stringTerms((String)tenantField, tenantIdTerms), new Query[0]);
        }
        if (includeNotDefinedTenant) {
            tenantQueryBuilder.should(QueryDSL.not((Query[])new Query[]{QueryDSL.exists((String)tenantField)}), new Query[0]);
        }
        if (tenantIdTerms.isEmpty() && !includeNotDefinedTenant) {
            tenantQueryBuilder.mustNot(QueryDSL.matchAll(), new Query[0]);
        }
        return tenantQueryBuilder.build().toQuery();
    }
}

