/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.usertask;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.DistributedByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.usertask.AbstractGroupByUserTaskInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.DurationScriptUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.ViewInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.service.DurationAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.interpreter.groupby.usertask.ProcessGroupByUserTaskInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByUserTaskDurationInterpreterOS
extends AbstractGroupByUserTaskInterpreterOS {
    private final MinMaxStatsServiceOS minMaxStatsService;
    private final DurationAggregationServiceOS durationAggregationService;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;
    private final ProcessGroupByUserTaskInterpreterHelper helper;

    public ProcessGroupByUserTaskDurationInterpreterOS(MinMaxStatsServiceOS minMaxStatsService, DurationAggregationServiceOS durationAggregationService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter, ProcessGroupByUserTaskInterpreterHelper helper) {
        this.minMaxStatsService = minMaxStatsService;
        this.durationAggregationService = durationAggregationService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
        this.helper = helper;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_USER_TASK_DURATION);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        UserTaskDurationTime userTaskDurationTime = this.getHelper().getUserTaskDurationTime(context);
        return this.durationAggregationService.createLimitedGroupByScriptedUserTaskDurationAggregation(boolQuery, context, this.getDurationScript(userTaskDurationTime), userTaskDurationTime).map(e -> this.createFilteredUserTaskAggregation(context, boolQuery, (String)e.getKey(), (Aggregation)e.getValue())).orElse(Map.of());
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return Optional.of(this.retrieveMinMaxDurationStats(context, baseQuery, this.getHelper().getUserTaskDurationTime(context)));
    }

    @Override
    protected void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        compositeCommandResult.setGroupByKeyOfNumericType(true);
        compositeCommandResult.setDistributedByKeyOfNumericType(this.distributedByInterpreter.isKeyOfNumericType(context));
        this.getFilteredUserTaskAggregation(response).ifPresent(userFilteredFlowNodes -> {
            List<CompositeCommandResult.GroupByResult> durationHistogramData = this.durationAggregationService.mapGroupByDurationResults(response, userFilteredFlowNodes.aggregations(), context);
            compositeCommandResult.setGroups(durationHistogramData);
        });
    }

    @Override
    protected DistributedByInterpreterOS<ProcessReportDataDto, ProcessExecutionPlan> getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    @Override
    protected ViewInterpreterOS<ProcessReportDataDto, ProcessExecutionPlan> getViewInterpreter() {
        return this.viewInterpreter;
    }

    @Override
    protected DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    @Override
    public ProcessGroupByUserTaskInterpreterHelper getHelper() {
        return this.helper;
    }

    private MinMaxStatDto retrieveMinMaxDurationStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery, UserTaskDurationTime userTaskDurationTime) {
        return this.minMaxStatsService.getScriptedMinMaxStats(baseQuery, this.getIndexNames(context), "flowNodeInstances", this.getDurationScript(userTaskDurationTime), Query.of(q -> q.bool(ModelElementFilterQueryUtilOS.createUserTaskFlowNodeTypeFilter().build())));
    }

    private Script getDurationScript(UserTaskDurationTime userTaskDurationTime) {
        return DurationScriptUtilOS.getUserTaskDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), "flowNodeInstances." + userTaskDurationTime.getDurationFieldName());
    }
}

