/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.none;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.ProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByNoneInterpreterOS
extends AbstractProcessGroupByInterpreterOS
implements ProcessGroupByInterpreterOS {
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;

    public ProcessGroupByNoneInterpreterOS(ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter) {
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_NONE);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query baseQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.distributedByInterpreter.createAggregations(context, baseQuery);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        List<CompositeCommandResult.DistributedByResult> distributions = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)response.aggregations(), context);
        CompositeCommandResult.GroupByResult groupByResult = CompositeCommandResult.GroupByResult.createGroupByNone(distributions);
        compositeCommandResult.setGroup(groupByResult);
    }

    public ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

