/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.decision;

import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.decision.DecisionDistributedByNoneInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.decision.AbstractDecisionGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.decision.DecisionViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionGroupByNoneInterpreterOS
extends AbstractDecisionGroupByInterpreterOS {
    private final DecisionDistributedByNoneInterpreterOS distributedByInterpreter;
    private final DecisionViewInterpreterFacadeOS viewInterpreter;

    public DecisionGroupByNoneInterpreterOS(DecisionDistributedByNoneInterpreterOS distributedByInterpreter, DecisionViewInterpreterFacadeOS viewInterpreter) {
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<DecisionGroupBy> getSupportedGroupBys() {
        return Set.of(DecisionGroupBy.DECISION_GROUP_BY_NONE);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return this.distributedByInterpreter.createAggregations(context, query);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        List<CompositeCommandResult.DistributedByResult> distributions = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)response.aggregations(), context);
        CompositeCommandResult.GroupByResult groupByResult = CompositeCommandResult.GroupByResult.createGroupByNone(distributions);
        compositeCommandResult.setGroup(groupByResult);
    }

    public DecisionDistributedByNoneInterpreterOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public DecisionViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

