/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.decision;

import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.group.DecisionGroupByEvaluationDateTimeDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.group.value.DecisionGroupByEvaluationDateTimeValueDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.service.db.os.report.context.DateAggregationContextOS;
import io.camunda.optimize.service.db.os.report.filter.DecisionQueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.decision.DecisionDistributedByNoneInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.decision.AbstractDecisionGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.util.FilterLimitedAggregationUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.decision.DecisionViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.service.DateAggregationServiceOS;
import io.camunda.optimize.service.db.os.report.service.MinMaxStatsServiceOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.types.MapUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionGroupByEvaluationDateTimeInterpreterOS
extends AbstractDecisionGroupByInterpreterOS {
    private final DateAggregationServiceOS dateAggregationService;
    private final MinMaxStatsServiceOS minMaxStatsService;
    private final DecisionQueryFilterEnhancerOS queryFilterEnhancer;
    private final DecisionDistributedByNoneInterpreterOS distributedByInterpreter;
    private final DecisionViewInterpreterFacadeOS viewInterpreter;

    public DecisionGroupByEvaluationDateTimeInterpreterOS(DateAggregationServiceOS dateAggregationService, MinMaxStatsServiceOS minMaxStatsService, DecisionQueryFilterEnhancerOS queryFilterEnhancer, DecisionDistributedByNoneInterpreterOS distributedByInterpreter, DecisionViewInterpreterFacadeOS viewInterpreter) {
        this.dateAggregationService = dateAggregationService;
        this.minMaxStatsService = minMaxStatsService;
        this.queryFilterEnhancer = queryFilterEnhancer;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<DecisionGroupBy> getSupportedGroupBys() {
        return Set.of(DecisionGroupBy.DECISION_GROUP_BY_EVALUATION_DATE_TIME);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        AggregateByDateUnit unit = this.getGroupBy(context.getReportData()).getUnit();
        return this.createAggregation(query, context, unit);
    }

    private Map<String, Aggregation> createAggregation(Query query, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context, AggregateByDateUnit unit) {
        MinMaxStatDto stats = this.minMaxStatsService.getMinMaxDateRange(context, query, this.getIndexNames(context), "evaluationDateTime");
        DateAggregationContext dateAggContext = ((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)((DateAggregationContextOS.DateAggregationContextOSBuilder)DateAggregationContextOS.builder().aggregateByDateUnit(unit)).dateField("evaluationDateTime")).minMaxStats(stats)).timezone(context.getTimezone())).subAggregations(this.distributedByInterpreter.createAggregations(context, query))).decisionFilters(context.getReportData().getFilter())).decisionQueryFilterEnhancer(this.queryFilterEnhancer)).filterContext(context.getFilterContext())).build();
        return this.dateAggregationService.createDecisionEvaluationDateAggregation((DateAggregationContextOS)dateAggContext).map(MapUtil::createFromPair).orElse(Map.of());
    }

    @Override
    public void addQueryResult(CompositeCommandResult result, SearchResponse<RawResult> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        result.setGroups(this.processAggregations(response, context));
        result.setGroupBySorting(context.getReportConfiguration().getSorting().orElseGet(() -> new ReportSortingDto("key", SortOrder.DESC)));
    }

    private DecisionGroupByEvaluationDateTimeValueDto getGroupBy(DecisionReportDataDto reportData) {
        return (DecisionGroupByEvaluationDateTimeValueDto)((DecisionGroupByEvaluationDateTimeDto)reportData.getGroupBy()).getValue();
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(SearchResponse<RawResult> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        Map aggregations = response.aggregations();
        if (aggregations == null) {
            return Collections.emptyList();
        }
        Optional<Map<String, Aggregate>> unwrappedLimitedAggregations = FilterLimitedAggregationUtilOS.unwrapFilterLimitedAggregations(aggregations);
        if (!unwrappedLimitedAggregations.isPresent()) {
            return Collections.emptyList();
        }
        Map<String, Map<String, Aggregate>> keyToAggregationMap = this.dateAggregationService.mapDateAggregationsToKeyAggregationMap(unwrappedLimitedAggregations.get(), context.getTimezone());
        return this.mapKeyToAggMapToGroupByResults(keyToAggregationMap, response, context);
    }

    private List<CompositeCommandResult.GroupByResult> mapKeyToAggMapToGroupByResults(Map<String, Map<String, Aggregate>> keyToAggregationMap, SearchResponse<RawResult> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return keyToAggregationMap.entrySet().stream().map(stringBucketEntry -> CompositeCommandResult.GroupByResult.createGroupByResult((String)stringBucketEntry.getKey(), this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)((Map)stringBucketEntry.getValue()), context))).collect(Collectors.toList());
    }

    public DecisionDistributedByNoneInterpreterOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public DecisionViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

