/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.distributedby.process;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessDistributedByNoneInterpreterOS
extends AbstractProcessDistributedByInterpreterOS {
    private final ProcessViewInterpreterFacadeOS viewInterpreter;

    public ProcessDistributedByNoneInterpreterOS(ProcessViewInterpreterFacadeOS viewInterpreter) {
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessDistributedBy> getSupportedDistributedBys() {
        return Set.of(ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_NONE);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return this.viewInterpreter.createAggregations(context);
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        CompositeCommandResult.ViewResult viewResult = this.viewInterpreter.retrieveResult(response, aggregations, context);
        return List.of(CompositeCommandResult.DistributedByResult.createDistributedByNoneResult(viewResult));
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return List.of(CompositeCommandResult.DistributedByResult.createDistributedByNoneResult(this.viewInterpreter.createEmptyResult(context)));
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

