/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter.util;

import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentStatus;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.OpenIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ResolvedIncidentFilterDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.filter.util.NestedDefinitionQueryBuilderOS;
import io.camunda.optimize.service.db.report.filter.util.IncidentFilterQueryUtil;
import io.camunda.optimize.util.types.ListUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;

public final class IncidentFilterQueryUtilOS
extends IncidentFilterQueryUtil {
    private static final NestedDefinitionQueryBuilderOS NESTED_DEFINITION_QUERY_BUILDER = new NestedDefinitionQueryBuilderOS("incidents", "definitionKey", "definitionVersion", "tenantId");
    private static final Map<Class<? extends ProcessFilterDto<?>>, Query> INCIDENT_VIEW_FILTER_INSTANCE_QUERIES = ImmutableMap.of(OpenIncidentFilterDto.class, (Object)IncidentFilterQueryUtilOS.createOpenIncidentTermQuery(), ResolvedIncidentFilterDto.class, (Object)IncidentFilterQueryUtilOS.createResolvedIncidentTermQuery());

    private IncidentFilterQueryUtilOS() {
    }

    public static Query createIncidentAggregationFilterQuery(ProcessReportDataDto reportData, DefinitionService definitionService) {
        Map filtersByDefinition = reportData.groupFiltersByDefinitionIdentifier();
        List<ProcessFilterDto<?>> allDefinitionFilters = filtersByDefinition.getOrDefault("all", Collections.emptyList());
        List<Query> definitionQueries = reportData.getDefinitions().stream().map(definitionDto -> {
            List<ProcessFilterDto<?>> filters = filtersByDefinition.getOrDefault(definitionDto.getIdentifier(), Collections.emptyList());
            return IncidentFilterQueryUtilOS.buildIncidentDefinitionQuery(definitionDto, definitionService, filters);
        }).toList();
        return new BoolQuery.Builder().minimumShouldMatch("1").filter(IncidentFilterQueryUtilOS.getIncidentFilterQueries(allDefinitionFilters)).should(definitionQueries).build().toQuery();
    }

    private static Query buildIncidentDefinitionQuery(ReportDataDefinitionDto definitionDto, DefinitionService definitionService, List<ProcessFilterDto<?>> filters) {
        Query nestedDocDefinitionQuery = NESTED_DEFINITION_QUERY_BUILDER.createNestedDocDefinitionQuery(definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds(), definitionService).build().toQuery();
        return new BoolQuery.Builder().must(nestedDocDefinitionQuery, new Query[0]).filter(IncidentFilterQueryUtilOS.getIncidentFilterQueries(filters)).build().toQuery();
    }

    private static List<Query> getIncidentFilterQueries(List<ProcessFilterDto<?>> filters) {
        return ListUtil.concat((List[])new List[]{IncidentFilterQueryUtilOS.getOpenIncidentFilterQueries(filters), IncidentFilterQueryUtilOS.getResolvedIncidentFilterQueries(filters), IncidentFilterQueryUtilOS.getExecutedFlowNodeFilterQueries(filters)});
    }

    private static List<Query> getOpenIncidentFilterQueries(List<ProcessFilterDto<?>> filters) {
        return IncidentFilterQueryUtilOS.containsViewLevelFilterOfType(filters, OpenIncidentFilterDto.class) ? List.of(IncidentFilterQueryUtilOS.createOpenIncidentTermQuery()) : List.of();
    }

    private static List<Query> getResolvedIncidentFilterQueries(List<ProcessFilterDto<?>> filters) {
        return IncidentFilterQueryUtilOS.containsViewLevelFilterOfType(filters, ResolvedIncidentFilterDto.class) ? List.of(IncidentFilterQueryUtilOS.createResolvedIncidentTermQuery()) : List.of();
    }

    public static List<Query> getExecutedFlowNodeFilterQueries(List<ProcessFilterDto<?>> filters) {
        return IncidentFilterQueryUtilOS.findAllViewLevelFiltersOfType(filters, ExecutedFlowNodeFilterDto.class).map(ProcessFilterDto::getData).map(executedFlowNodeFilterData -> ModelElementFilterQueryUtilOS.createExecutedFlowNodeFilterQuery(executedFlowNodeFilterData, IncidentFilterQueryUtilOS.nestedFieldReference("activityId"), new BoolQuery.Builder())).toList();
    }

    public static Optional<Query> instanceFilterForRelevantViewLevelFiltersQuery(List<ProcessFilterDto<?>> filters) {
        List<Query> filterQueries = filters.stream().filter(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel())).filter(filter -> INCIDENT_VIEW_FILTER_INSTANCE_QUERIES.containsKey(filter.getClass())).map(filter -> INCIDENT_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass())).toList();
        return filterQueries.isEmpty() ? Optional.empty() : Optional.of(QueryDSL.nested((String)"incidents", (Query)QueryDSL.and(filterQueries), (ChildScoreMode)ChildScoreMode.None));
    }

    public static Query createResolvedIncidentTermQuery() {
        return QueryDSL.term((String)"incidents.incidentStatus", (String)IncidentStatus.RESOLVED.getId());
    }

    public static Query createOpenIncidentTermQuery() {
        return IncidentFilterQueryUtilOS.createOpenIncidentTermQuery(new BoolQuery.Builder());
    }

    public static Query createDeletedIncidentTermQuery() {
        return IncidentFilterQueryUtilOS.createDeletedIncidentTermQuery(new BoolQuery.Builder());
    }

    private static Query createDeletedIncidentTermQuery(BoolQuery.Builder boolQueryBuilder) {
        return boolQueryBuilder.must(QueryDSL.term((String)"incidents.incidentStatus", (String)IncidentStatus.DELETED.getId()), new Query[0]).build().toQuery();
    }

    private static Query createOpenIncidentTermQuery(BoolQuery.Builder boolQueryBuilder) {
        return boolQueryBuilder.must(QueryDSL.term((String)"incidents.incidentStatus", (String)IncidentStatus.OPEN.getId()), new Query[0]).build().toQuery();
    }
}

