/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.MultipleVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.AbstractProcessVariableQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.QueryFilterOS;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessMultiVariableQueryFilterOS
extends AbstractProcessVariableQueryFilterOS
implements QueryFilterOS<MultipleVariableFilterDataDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessMultiVariableQueryFilterOS.class);

    @Override
    public List<Query> filterQueries(List<MultipleVariableFilterDataDto> multiVariableFilters, FilterContext filterContext) {
        return multiVariableFilters == null ? List.of() : multiVariableFilters.stream().map(multiVariableFilter -> this.buildMultiVariableFilterQuery((MultipleVariableFilterDataDto)multiVariableFilter, filterContext)).toList();
    }

    private Query buildMultiVariableFilterQuery(MultipleVariableFilterDataDto multipleVariableFilter, FilterContext filterContext) {
        List<Query> queries = multipleVariableFilter.getData().stream().map(variableFilter -> this.createFilterQuery((VariableFilterDataDto<?>)variableFilter, filterContext.getTimezone())).toList();
        return QueryDSL.or(queries);
    }
}

