/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.MembershipFilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutedFlowNodeFilterDataDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.QueryFilterOS;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ExecutedFlowNodeQueryFilterOS
implements QueryFilterOS<ExecutedFlowNodeFilterDataDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutedFlowNodeQueryFilterOS.class);

    @Override
    public List<Query> filterQueries(List<ExecutedFlowNodeFilterDataDto> flowNodeFilters, FilterContext filterContext) {
        return flowNodeFilters.stream().map(this::createFilterQuery).toList();
    }

    private Query createFilterQuery(ExecutedFlowNodeFilterDataDto flowNodeFilter) {
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        if (MembershipFilterOperator.IN == flowNodeFilter.getOperator()) {
            for (String value : flowNodeFilter.getValues()) {
                boolQueryBuilder.should(QueryDSL.nested((String)"flowNodeInstances", (Query)QueryDSL.term((String)this.nestedFlowNodeIdFieldLabel(), (String)value), (ChildScoreMode)ChildScoreMode.None), new Query[0]);
            }
        } else if (MembershipFilterOperator.NOT_IN == flowNodeFilter.getOperator()) {
            for (String value : flowNodeFilter.getValues()) {
                boolQueryBuilder.mustNot(QueryDSL.nested((String)"flowNodeInstances", (Query)QueryDSL.term((String)this.nestedFlowNodeIdFieldLabel(), (String)value), (ChildScoreMode)ChildScoreMode.None), new Query[0]);
            }
        } else {
            LOG.error("Could not filter for flow nodes. Operator [{}] is not allowed! Use either [in] or [not in]", (Object)flowNodeFilter.getOperator());
        }
        return boolQueryBuilder.build().toQuery();
    }

    private String nestedFlowNodeIdFieldLabel() {
        return "flowNodeInstances.flowNodeId";
    }
}

