/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.query.sharing.DashboardShareRestDto;
import io.camunda.optimize.dto.optimize.query.sharing.ReportShareRestDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.reader.SharingReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class SharingReaderOS
implements SharingReader {
    private static final Logger LOG = LoggerFactory.getLogger(SharingReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public SharingReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public Optional<ReportShareRestDto> getReportShare(String shareId) {
        LOG.debug("Fetching report share with id [{}]", (Object)shareId);
        GetRequest.Builder getReqBuilder = new GetRequest.Builder().index("report-share").id(shareId);
        String errorMessage = String.format("Could not fetch report share with id [%s]", shareId);
        GetResponse getResponse = this.osClient.get(getReqBuilder, ReportShareRestDto.class, errorMessage);
        if (getResponse.found()) {
            return Optional.ofNullable((ReportShareRestDto)getResponse.source());
        }
        return Optional.empty();
    }

    @Override
    public Optional<DashboardShareRestDto> findDashboardShare(String shareId) {
        LOG.debug("Fetching dashboard share with id [{}]", (Object)shareId);
        GetRequest.Builder getReqBuilder = new GetRequest.Builder().index("dashboard-share").id(shareId);
        String errorMessage = String.format("Could not fetch dashboard share with id [%s]", shareId);
        GetResponse getResponse = this.osClient.get(getReqBuilder, DashboardShareRestDto.class, errorMessage);
        if (getResponse.found()) {
            return Optional.ofNullable((DashboardShareRestDto)getResponse.source());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ReportShareRestDto> findShareForReport(String reportId) {
        LOG.debug("Fetching share for resource [{}]", (Object)reportId);
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder().must(QueryDSL.term((String)"reportId", (String)reportId), new Query[0]);
        return this.findReportShareByQuery(boolQueryBuilder.build());
    }

    @Override
    public Optional<DashboardShareRestDto> findShareForDashboard(String dashboardId) {
        LOG.debug("Fetching share for resource [{}]", (Object)dashboardId);
        SearchResponse<DashboardShareRestDto> searchResponse = this.performSearchShareForDashboardIdRequest(dashboardId);
        List<DashboardShareRestDto> results = OpensearchReaderUtil.extractResponseValues(searchResponse);
        if (!results.isEmpty()) {
            return Optional.of(results.get(0));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, ReportShareRestDto> findShareForReports(List<String> reports) {
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder().must(QueryDSL.terms((String)"reportId", reports, FieldValue::of), new Query[0]);
        return this.findSharesByQuery(boolQueryBuilder.build(), "report-share", ReportShareRestDto.class, "Was not able to retrieve report shares!").stream().collect(Collectors.toMap(ReportShareRestDto::getReportId, Function.identity()));
    }

    @Override
    public Map<String, DashboardShareRestDto> findShareForDashboards(List<String> dashboards) {
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder().must(QueryDSL.terms((String)"dashboardId", dashboards, FieldValue::of), new Query[0]);
        return this.findSharesByQuery(boolQueryBuilder.build(), "dashboard-share", DashboardShareRestDto.class, "Was not able to retrieve dashboards shares!").stream().collect(Collectors.toMap(DashboardShareRestDto::getDashboardId, Function.identity()));
    }

    @Override
    public long getShareCount(String indexName) {
        String errorMessage = String.format("Was not able to retrieve count for type: %s", indexName);
        return this.osClient.count(indexName, errorMessage);
    }

    private Optional<ReportShareRestDto> findReportShareByQuery(BoolQuery query) {
        SearchRequest.Builder searchReqBuilder = new SearchRequest.Builder().index("report-share", new String[0]).size(Integer.valueOf(1)).query(query.toQuery());
        String errorMessage = "Was not able to fetch report share.";
        SearchResponse searchResponse = this.osClient.search(searchReqBuilder, ReportShareRestDto.class, "Was not able to fetch report share.");
        List results = OpensearchReaderUtil.extractResponseValues(searchResponse);
        if (!results.isEmpty()) {
            return Optional.of((ReportShareRestDto)results.get(0));
        }
        return Optional.empty();
    }

    private SearchResponse<DashboardShareRestDto> performSearchShareForDashboardIdRequest(String dashboardId) {
        BoolQuery boolQuery = new BoolQuery.Builder().must(QueryDSL.term((String)"dashboardId", (String)dashboardId), new Query[0]).build();
        SearchRequest.Builder searchReqBuilder = new SearchRequest.Builder().index("dashboard-share", new String[0]).size(Integer.valueOf(1)).query(boolQuery.toQuery());
        String errorMessage = String.format("Was not able to fetch share for dashboard with id [%s]", dashboardId);
        return this.osClient.search(searchReqBuilder, DashboardShareRestDto.class, errorMessage);
    }

    private <T> List<T> findSharesByQuery(BoolQuery query, String index, Class<T> responseType, String errorMessage) {
        OpenSearchDocumentOperations.AggregatedResult scrollResp;
        SearchRequest.Builder searchReqBuilder = new SearchRequest.Builder().index(index, new String[0]).size(Integer.valueOf(1000)).query(query.toQuery()).scroll(RequestDSL.time((String)String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())));
        try {
            scrollResp = this.osClient.retrieveAllScrollResults(searchReqBuilder, responseType);
        }
        catch (IOException e) {
            LOG.error(errorMessage, (Throwable)e);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(scrollResp);
    }
}

