/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.get.GetResult;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.opensearch.core.search.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpensearchReaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OpensearchReaderUtil.class);

    public static <T> List<T> extractResponseValues(SearchResponse<T> searchResponse) {
        return Optional.ofNullable(searchResponse).map(SearchResult::hits).map(HitsMetadata::hits).map(hits -> hits.stream().map(Hit::source).toList()).orElseThrow(() -> {
            String reason = "Was not able to parse response values from OpenSearch";
            LOG.error("Was not able to parse response values from OpenSearch");
            return new OptimizeRuntimeException("Was not able to parse response values from OpenSearch");
        });
    }

    public static <T> List<T> extractResponseValues(SearchResponse<T> searchResponse, Function<Hit<T>, T> mappingFunction) {
        return Optional.ofNullable(searchResponse).map(SearchResult::hits).map(HitsMetadata::hits).map(hits -> hits.stream().map(mappingFunction).toList()).orElseThrow(() -> {
            String reason = "Was not able to parse response values from OpenSearch";
            LOG.error("Was not able to parse response values from OpenSearch");
            return new OptimizeRuntimeException("Was not able to parse response values from OpenSearch");
        });
    }

    public static <T> Set<String> extractAggregatedResponseValues(SearchResponse<T> searchResponse, String aggPath) {
        return Optional.ofNullable(searchResponse).map(response -> (Aggregate)response.aggregations().get(aggPath)).filter(Aggregate::isSterms).map(Aggregate::sterms).map(MultiBucketAggregateBase::buckets).map(Buckets::array).map(Collection::stream).map(streamBuckets -> streamBuckets.map(StringTermsBucket::key).collect(Collectors.toSet())).orElseThrow(() -> {
            String reason = String.format("Was not able to parse aggregated sterm response values from OpenSearch with path %s", aggPath);
            LOG.error(reason);
            return new OptimizeRuntimeException(reason);
        });
    }

    public static <T> List<T> extractAggregatedResponseValues(OpenSearchDocumentOperations.AggregatedResult<Hit<T>> searchResponse) {
        return OpensearchReaderUtil.extractAggregatedResponseValues(searchResponse, Hit::source);
    }

    public static <T> List<T> extractAggregatedResponseValues(OpenSearchDocumentOperations.AggregatedResult<Hit<T>> searchResponse, Function<Hit<T>, T> mappingFunction) {
        return Optional.ofNullable(searchResponse).map(OpenSearchDocumentOperations.AggregatedResult::values).map(hits -> hits.stream().map(mappingFunction).collect(Collectors.toList())).orElseThrow(() -> {
            String reason = "Was not able to parse response aggregations from OpenSearch";
            LOG.error("Was not able to parse response aggregations from OpenSearch");
            return new OptimizeRuntimeException("Was not able to parse response aggregations from OpenSearch");
        });
    }

    public static <T> Optional<T> processGetResponse(GetResult<T> getResponse) {
        return Optional.ofNullable(getResponse).filter(GetResult::found).map(GetResult::source);
    }

    public static <T> Collection<? extends T> mapHits(HitsMetadata<JsonData> searchHits, int resultLimit, Class<T> typeClass, Function<Hit<T>, T> mappingFunction) {
        ArrayList results = new ArrayList();
        for (Hit hit : searchHits.hits()) {
            if (results.size() >= resultLimit) break;
            try {
                Optional<JsonData> optionalMappedHit = Optional.ofNullable((JsonData)hit.source());
                optionalMappedHit.ifPresent(hitValue -> {
                    try {
                        Object definitionDto = hitValue.to(typeClass);
                        Hit adaptedHit = new Hit.Builder().index(hit.index()).source(definitionDto).build();
                        Object enrichedDto = mappingFunction.apply(adaptedHit);
                        results.add(enrichedDto);
                    }
                    catch (Exception e) {
                        String reason = "While mapping search results to class {} it was not possible to deserialize a hit from OpenSearch!";
                        LOG.error("While mapping search results to class {} it was not possible to deserialize a hit from OpenSearch!", (Object)typeClass.getSimpleName(), (Object)e);
                        throw new OptimizeRuntimeException("While mapping search results to class {} it was not possible to deserialize a hit from OpenSearch!");
                    }
                });
            }
            catch (Exception e) {
                String reason = "While mapping search results to class {} it was not possible to deserialize a hit from Opensearch!";
                LOG.error("While mapping search results to class {} it was not possible to deserialize a hit from Opensearch!", (Object)typeClass.getSimpleName(), (Object)e);
                throw new OptimizeRuntimeException("While mapping search results to class {} it was not possible to deserialize a hit from Opensearch!");
            }
        }
        return results;
    }
}

