/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.query.dashboard.InstantDashboardDataDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.reader.InstantDashboardMetadataReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Optional;
import org.opensearch.client.opensearch.core.GetResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class InstantDashboardMetadataReaderOS
implements InstantDashboardMetadataReader {
    private static final Logger LOG = LoggerFactory.getLogger(InstantDashboardMetadataReaderOS.class);
    private final OptimizeOpenSearchClient osClient;

    public InstantDashboardMetadataReaderOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public Optional<String> getInstantDashboardIdFor(String processDefinitionKey, String template) throws OptimizeRuntimeException {
        LOG.debug("Fetching Instant preview dashboard ID for [{}] with template [{}] ", (Object)processDefinitionKey, (Object)template);
        InstantDashboardDataDto dashboardDataDto = new InstantDashboardDataDto();
        dashboardDataDto.setTemplateName(template);
        dashboardDataDto.setProcessDefinitionKey(processDefinitionKey);
        String instantDashboardKey = dashboardDataDto.getInstantDashboardId();
        GetResponse getResponse = this.osClient.get("instant-dashboard", instantDashboardKey, InstantDashboardDataDto.class, String.format("Could not fetch Instant preview dashboard with key [%s]", instantDashboardKey));
        if (getResponse.found()) {
            return Optional.of(((InstantDashboardDataDto)getResponse.source()).getDashboardId());
        }
        String reason = "Could not find dashboard data for key [" + instantDashboardKey + "] in Opensearch.";
        LOG.error(reason);
        return Optional.empty();
    }
}

