/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.reader.DefinitionInstanceReader;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DefinitionInstanceReaderOS
extends DefinitionInstanceReader {
    private static final Logger LOG = LoggerFactory.getLogger(DefinitionInstanceReaderOS.class);
    final OptimizeIndexNameService indexNameService;
    final OptimizeOpenSearchClient osClient;

    public DefinitionInstanceReaderOS(OptimizeIndexNameService indexNameService, OptimizeOpenSearchClient osClient) {
        this.indexNameService = indexNameService;
        this.osClient = osClient;
    }

    @Override
    public Set<String> getAllExistingDefinitionKeys(DefinitionType type, Set<String> instanceIds) {
        Query idQuery = CollectionUtils.isEmpty(instanceIds) ? QueryDSL.matchAll() : QueryDSL.stringTerms((String)this.resolveInstanceIdFieldForType(type), instanceIds);
        String defKeyAggName = "definitionKeyAggregation";
        Aggregation definitionKeyAgg = AggregationDSL.termAggregation((String)this.resolveDefinitionKeyFieldForType(type), (int)10000)._toAggregation();
        SearchRequest.Builder requestBuilder = new SearchRequest.Builder().index(this.indexNameService.getOptimizeIndexAliasForIndex(this.resolveIndexMultiAliasForType(type)), new String[0]).aggregations("definitionKeyAggregation", definitionKeyAgg).query(idQuery).source(QueryDSL.sourceExcluded());
        try {
            return ((Aggregate)this.osClient.getRichOpenSearchClient().doc().searchAggregationsUnsafe(requestBuilder).get("definitionKeyAggregation")).sterms().buckets().array().stream().map(StringTermsBucket::key).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException(String.format("Was not able to retrieve definition keys for instances of type %s", type), (Throwable)e);
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)type, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to retrieve definition keys for instances because no {} instance indices exist. Returning empty set.", (Object)type);
                return Collections.emptySet();
            }
            throw e;
        }
    }
}

