/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisRequestDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.builders.OptimizeCountRequestBuilderOS;
import io.camunda.optimize.service.db.os.report.filter.ProcessQueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.schema.index.ProcessInstanceIndexOS;
import io.camunda.optimize.service.db.os.util.DefinitionQueryUtilOS;
import io.camunda.optimize.service.db.reader.BranchAnalysisReader;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.schema.index.AbstractInstanceIndex;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.LogUtil;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Set;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.CountRequest;
import org.opensearch.client.opensearch.core.CountResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class BranchAnalysisReaderOS
extends BranchAnalysisReader {
    private static final Logger LOG = LoggerFactory.getLogger(BranchAnalysisReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ProcessQueryFilterEnhancerOS queryFilterEnhancer;
    private final ProcessDefinitionReader processDefinitionReader;

    public BranchAnalysisReaderOS(DefinitionService definitionService, OptimizeOpenSearchClient osClient, ProcessQueryFilterEnhancerOS queryFilterEnhancer, ProcessDefinitionReader processDefinitionReader) {
        super(definitionService);
        this.osClient = osClient;
        this.queryFilterEnhancer = queryFilterEnhancer;
        this.processDefinitionReader = processDefinitionReader;
    }

    @Override
    protected long calculateReachedEndEventFlowNodeCount(String flowNodeId, BranchAnalysisRequestDto request, Set<String> activitiesToExclude, ZoneId timezone) {
        BoolQuery.Builder builder = this.buildBaseQuery(request, activitiesToExclude).must(this.createMustMatchFlowNodeIdQuery(request.getGateway()), new Query[0]).must(this.createMustMatchFlowNodeIdQuery(flowNodeId), new Query[0]).must(this.createMustMatchFlowNodeIdQuery(request.getEnd()), new Query[0]);
        return this.executeQuery(request, builder, timezone);
    }

    @Override
    protected long calculateFlowNodeCount(String flowNodeId, BranchAnalysisRequestDto request, Set<String> activitiesToExclude, ZoneId timezone) {
        BoolQuery.Builder builder = this.buildBaseQuery(request, activitiesToExclude).must(this.createMustMatchFlowNodeIdQuery(request.getGateway()), new Query[0]).must(this.createMustMatchFlowNodeIdQuery(flowNodeId), new Query[0]);
        return this.executeQuery(request, builder, timezone);
    }

    private BoolQuery.Builder buildBaseQuery(BranchAnalysisRequestDto request, Set<String> activitiesToExclude) {
        BoolQuery.Builder queryBuilder = DefinitionQueryUtilOS.createDefinitionQuery(request.getProcessDefinitionKey(), request.getProcessDefinitionVersions(), request.getTenantIds(), (AbstractInstanceIndex)new ProcessInstanceIndexOS(request.getProcessDefinitionKey()), this.processDefinitionReader::getLatestVersionToKey);
        this.excludeFlowNodes(activitiesToExclude, queryBuilder);
        return queryBuilder;
    }

    private void excludeFlowNodes(Set<String> flowNodeIdsToExclude, BoolQuery.Builder query) {
        for (String excludeFlowNodeId : flowNodeIdsToExclude) {
            query.mustNot(this.createMustMatchFlowNodeIdQuery(excludeFlowNodeId), new Query[0]);
        }
    }

    private Query createMustMatchFlowNodeIdQuery(String flowNodeId) {
        return Query.of(qu -> qu.nested(NestedQuery.of(b -> b.path("flowNodeInstances").query(q -> q.term(t -> t.field("flowNodeInstances.flowNodeId").value(FieldValue.of((String)flowNodeId)))).scoreMode(ChildScoreMode.None))));
    }

    private long executeQuery(BranchAnalysisRequestDto request, BoolQuery.Builder bool, ZoneId timezone) {
        List<Query> filterQueries = this.queryFilterEnhancer.filterQueries(request.getFilter(), FilterContext.builder().timezone(timezone).build());
        bool.filter(filterQueries);
        CountRequest countRequest = OptimizeCountRequestBuilderOS.of(b -> b.optimizeIndex(this.osClient, InstanceIndexUtil.getProcessInstanceIndexAliasName((String)request.getProcessDefinitionKey())).query(q -> q.bool(bool.build())));
        try {
            CountResponse countResponse = this.osClient.getOpenSearchClient().count(countRequest);
            return countResponse.count();
        }
        catch (IOException e) {
            String reason = LogUtil.sanitizeLogMessage((String)String.format("Was not able to perform branch analysis on process definition with key [%s] and versions [%s}]", request.getProcessDefinitionKey(), request.getProcessDefinitionVersions()));
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to perform branch analysis because the required instance index {} does not exist. Returning 0 instead.", (Object)LogUtil.sanitizeLogMessage((String)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)request.getProcessDefinitionKey())));
                return 0L;
            }
            throw e;
        }
    }
}

