/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.filter.util;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.OperatorMultipleValuesFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.OperatorMultipleValuesVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;

public class OperatorMultipleValuesVariableFilterDataDtoUtil {
    public static void validateMultipleValuesFilterDataDto(OperatorMultipleValuesVariableFilterDataDto dto) {
        if (CollectionUtils.isEmpty((Collection)((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues())) {
            throw new OptimizeValidationException("Filter values are not allowed to be empty.");
        }
        if (FilterOperator.RELATIVE_OPERATORS.contains(((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator()) && ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues().contains(null)) {
            throw new OptimizeValidationException("Filter values are not allowed to contain `null` if a relative operator is used.");
        }
    }

    public static Object retrieveValue(OperatorMultipleValuesVariableFilterDataDto dto) {
        String value = (String)((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues().get(0);
        try {
            if (value != null) {
                return switch (dto.getType()) {
                    case VariableType.INTEGER -> Integer.parseInt(value);
                    case VariableType.LONG -> Long.parseLong(value);
                    case VariableType.SHORT -> Short.parseShort(value);
                    case VariableType.DOUBLE -> Double.parseDouble(value);
                    default -> value;
                };
            }
            return null;
        }
        catch (NumberFormatException exception) {
            throw new OptimizeRuntimeException("Error trying to parse value for filter: " + value);
        }
    }
}

