/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.util.ObjectBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.dashboard.InstantDashboardDataDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.writer.InstantDashboardMetadataWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class InstantDashboardMetadataWriterES
implements InstantDashboardMetadataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(InstantDashboardMetadataWriterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;

    public InstantDashboardMetadataWriterES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public void saveInstantDashboard(InstantDashboardDataDto dashboardDataDto) {
        LOG.debug("Writing new Instant preview dashboard to Elasticsearch");
        String id = dashboardDataDto.getInstantDashboardId();
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "instant-dashboard").id(id).document((Object)dashboardDataDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created) && !indexResponse.result().equals((Object)Result.Updated)) {
                String message = "Could not write Instant preview dashboard data to Elasticsearch. Maybe the connection to Elasticsearch got lost?";
                LOG.error("Could not write Instant preview dashboard data to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
                throw new OptimizeRuntimeException("Could not write Instant preview dashboard data to Elasticsearch. Maybe the connection to Elasticsearch got lost?");
            }
        }
        catch (IOException e) {
            String errorMessage = "Could not write Instant preview dashboard data to Elasticsearch.";
            LOG.error("Could not write Instant preview dashboard data to Elasticsearch.", (Throwable)e);
            throw new OptimizeRuntimeException("Could not write Instant preview dashboard data to Elasticsearch.", (Throwable)e);
        }
        LOG.debug("Instant preview dashboard information with id [{}] has been created", (Object)id);
    }

    @Override
    public List<String> deleteOutdatedTemplateEntriesAndGetExistingDashboardIds(List<Long> hashesAllowed) throws IOException {
        ArrayList<String> dashboardIdsToBeDeleted = new ArrayList<String>();
        SearchResponse searchResponse = this.esClient.search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"instant-dashboard"}).query(q -> q.bool(b -> b.mustNot(m -> m.terms(t -> t.field("templateHash").terms(tt -> tt.value(hashesAllowed.stream().map(FieldValue::of).toList()))))))), Map.class);
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        LOG.debug("Deleting [{}] instant dashboard documents by id with bulk request.", (Object)searchResponse.hits().hits().size());
        searchResponse.hits().hits().forEach(hit -> {
            dashboardIdsToBeDeleted.add((String)((Map)hit.source()).get("dashboardId"));
            bulkRequestBuilder.operations(o -> o.delete(OptimizeDeleteOperationBuilderES.of(d -> (ObjectBuilder)d.optimizeIndex(this.esClient, "instant-dashboard").id(hit.id()))));
        });
        this.esClient.doBulkRequest(searchResponse.hits().hits().isEmpty() ? null : bulkRequestBuilder.build(), "instant-dashboard", false);
        return dashboardIdsToBeDeleted;
    }
}

