/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.service;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StatsAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.util.ObjectBuilder;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.report.interpreter.util.FilterLimitedAggregationUtilES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.service.AbstractMinMaxStatsService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticSearchCondition.class})
@Component
public class MinMaxStatsServiceES
extends AbstractMinMaxStatsService {
    private static final Logger LOG = LoggerFactory.getLogger(MinMaxStatsServiceES.class);
    private final OptimizeElasticsearchClient esClient;

    public MinMaxStatsServiceES(OptimizeElasticsearchClient esClient) {
        this.esClient = esClient;
    }

    public MinMaxStatDto getMinMaxDateRange(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String field) {
        return this.getMinMaxDateRangeForNestedField(context, query, indexNames, field, field, null, null);
    }

    public MinMaxStatDto getMinMaxDateRangeForCrossField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String firstField, String secondField) {
        return this.getMinMaxDateRangeForNestedField(context, query, indexNames, firstField, secondField, null, null);
    }

    public MinMaxStatDto getMinMaxDateRangeForNestedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String field, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return this.getMinMaxDateRangeForNestedField(context, query, indexNames, field, field, pathForNestedStatsAgg, filterQueryToWrapStatsWith);
    }

    public MinMaxStatDto getMinMaxNumberRangeForScriptedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, Script script) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getScriptedMinMaxStats(query, indexNames, null, script));
    }

    public MinMaxStatDto getMinMaxNumberRangeForNestedScriptedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String pathForNestedStatsAgg, Script script) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getScriptedMinMaxStats(query, indexNames, pathForNestedStatsAgg, script, null));
    }

    public MinMaxStatDto getMinMaxNumberRangeForNestedScriptedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String pathForNestedStatsAgg, Script script, Query filterQueryToWrapStatsWith) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getScriptedMinMaxStats(query, indexNames, pathForNestedStatsAgg, script, filterQueryToWrapStatsWith));
    }

    public MinMaxStatDto getScriptedMinMaxStats(Query query, String[] indexNames, String pathForNestedStatsAgg, Script script) {
        return this.getScriptedMinMaxStats(query, indexNames, pathForNestedStatsAgg, script, null);
    }

    public MinMaxStatDto getScriptedMinMaxStats(Query query, String[] indexNames, String pathForNestedStatsAgg, Script script, Query filterQueryToWrapStatsWith) {
        SearchResponse response;
        Supplier<Map> supplier = () -> {
            Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().stats(s -> (ObjectBuilder)s.script(script));
            Map<String, Aggregation.Builder.ContainerBuilder> statsAggregation = Map.of("statsAggField1", builder);
            if (filterQueryToWrapStatsWith != null) {
                statsAggregation = FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation("filterAggField1", filterQueryToWrapStatsWith, statsAggregation);
            }
            return statsAggregation;
        };
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, indexNames).query(query).source(o -> o.fetch(Boolean.valueOf(false))).size(Integer.valueOf(0)).aggregations(Optional.ofNullable(pathForNestedStatsAgg).map(nestedPath -> new Aggregation.Builder().nested(n -> n.path(nestedPath))).map(arg_0 -> MinMaxStatsServiceES.lambda$getScriptedMinMaxStats$9((Supplier)supplier, arg_0)).orElse(((Map)supplier.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build())))));
        try {
            response = this.esClient.search(searchRequest, Object.class);
        }
        catch (IOException e) {
            String reason = String.format("Could not retrieve stats for script %s on indices %s", script.toString(), Arrays.toString(indexNames));
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (RuntimeException e) {
            return this.returnEmptyResultIfInstanceIndexNotFound(e, indexNames);
        }
        StatsAggregate minMaxStats = this.retrieveNestedWrappedStatsAggregation("nestedAggField1", "filterAggField1", "statsAggField1", response);
        return new MinMaxStatDto(minMaxStats.min(), minMaxStats.max());
    }

    public MinMaxStatDto getSingleFieldMinMaxStats(Query query, String[] indexNames, String field, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return this.getCrossFieldMinMaxStats(query, indexNames, field, field, null, pathForNestedStatsAgg, filterQueryToWrapStatsWith);
    }

    public MinMaxStatDto getSingleFieldMinMaxStats(Query query, String[] indexNames, String field, String format, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return this.getCrossFieldMinMaxStats(query, indexNames, field, field, format, pathForNestedStatsAgg, filterQueryToWrapStatsWith);
    }

    private MinMaxStatDto getMinMaxDateRangeForNestedField(ExecutionContext<? extends SingleReportDataDto, ?> context, Query query, String[] indexNames, String firstField, String secondField, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        return context.getCombinedRangeMinMaxStats().orElseGet(() -> this.getCrossFieldMinMaxStats(query, indexNames, firstField, secondField, "yyyy-MM-dd'T'HH:mm:ss.SSSZ", pathForNestedStatsAgg, filterQueryToWrapStatsWith));
    }

    private MinMaxStatDto getCrossFieldMinMaxStats(Query query, String[] indexNames, String firstField, String secondField, String format, String pathForNestedStatsAgg, Query filterQueryToWrapStatsWith) {
        SearchResponse response;
        Map<String, Aggregation.Builder.ContainerBuilder> statsAggField1 = this.createStatsAggregation("statsAggField1", firstField, format);
        Map<String, Aggregation.Builder.ContainerBuilder> statsAggField2 = this.createStatsAggregation("statsAggField2", secondField, format);
        if (filterQueryToWrapStatsWith != null) {
            statsAggField1 = FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation("filterAggField1", filterQueryToWrapStatsWith, statsAggField1);
            statsAggField2 = FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation("filterAggField2", filterQueryToWrapStatsWith, statsAggField2);
        }
        if (pathForNestedStatsAgg != null) {
            Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().nested(n -> n.path(pathForNestedStatsAgg));
            builder.aggregations(statsAggField1.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build())));
            statsAggField1 = Map.of("nestedAggField1", builder);
            Aggregation.Builder.ContainerBuilder builder1 = new Aggregation.Builder().nested(n -> n.path(pathForNestedStatsAgg));
            builder1.aggregations(statsAggField2.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build())));
            statsAggField2 = Map.of("nestedAggField2", builder1);
        }
        try {
            Map<String, Aggregation.Builder.ContainerBuilder> finalStatsAggField = statsAggField1;
            Map<String, Aggregation.Builder.ContainerBuilder> finalStatsAggField1 = statsAggField2;
            response = this.esClient.search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, indexNames).query(query).source(o -> o.fetch(Boolean.valueOf(false))).aggregations(finalStatsAggField.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build()))).aggregations(finalStatsAggField1.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build()))).size(Integer.valueOf(0))), Object.class);
        }
        catch (IOException e2) {
            String reason = String.format("Could not retrieve stats for firstField %s and secondField %s on index %s", firstField, secondField, Arrays.toString(indexNames));
            LOG.error(reason, (Throwable)e2);
            throw new OptimizeRuntimeException(reason, (Throwable)e2);
        }
        catch (RuntimeException e3) {
            return this.returnEmptyResultIfInstanceIndexNotFound(e3, indexNames);
        }
        return this.mapCrossFieldStatAggregationsToStatDto(response);
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createStatsAggregation(String aggregationName, String aggregationField, String format) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().stats(s -> {
            s.field(aggregationField);
            if (format != null) {
                s.format(format);
            }
            return s;
        });
        return Map.of(aggregationName, builder);
    }

    private MinMaxStatDto mapCrossFieldStatAggregationsToStatDto(SearchResponse response) {
        StatsAggregate minMaxStats1 = this.retrieveNestedWrappedStatsAggregation("nestedAggField1", "filterAggField1", "statsAggField1", response);
        StatsAggregate minMaxStats2 = this.retrieveNestedWrappedStatsAggregation("nestedAggField2", "filterAggField2", "statsAggField2", response);
        StatsAggregate minStats = minMaxStats1.min() < minMaxStats2.min() ? minMaxStats1 : minMaxStats2;
        StatsAggregate maxStats = minMaxStats1.max() > minMaxStats2.max() ? minMaxStats1 : minMaxStats2;
        return new MinMaxStatDto(minStats.min(), maxStats.max(), minStats.minAsString(), maxStats.maxAsString());
    }

    private StatsAggregate retrieveNestedWrappedStatsAggregation(String nestedAggName, String filterAggName, String statsAggName, SearchResponse<?> response) {
        Map unnestedAggs = response.aggregations().containsKey(nestedAggName) ? ((Aggregate)response.aggregations().get(nestedAggName)).nested().aggregations() : response.aggregations();
        Optional<Map<String, Aggregate>> unwrappedAggs = FilterLimitedAggregationUtilES.unwrapFilterLimitedAggregations(filterAggName, unnestedAggs);
        return unwrappedAggs.orElse(unnestedAggs).get(statsAggName).stats();
    }

    private static /* synthetic */ Map lambda$getScriptedMinMaxStats$9(Supplier supplier, Aggregation.Builder.ContainerBuilder nestedAgg) {
        nestedAgg.aggregations(((Map)supplier.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build())));
        return Map.of("nestedAggField1", nestedAgg.build());
    }
}

