/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.service;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.SingleReportConfigurationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.custom_buckets.CustomBucketDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.ComparisonOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.DurationFilterDataDto;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.util.DurationScriptUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.util.FilterLimitedAggregationUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.util.NumberHistogramAggregationUtilES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.report.service.DurationAggregationService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DurationAggregationServiceES
extends DurationAggregationService {
    private final MinMaxStatsServiceES minMaxStatsService;
    private final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;

    public DurationAggregationServiceES(MinMaxStatsServiceES minMaxStatsService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter) {
        this.minMaxStatsService = minMaxStatsService;
        this.distributedByInterpreter = distributedByInterpreter;
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createLimitedGroupByScriptedDurationAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Script durationCalculationScript) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxNumberRangeForScriptedField(context, Query.of(q -> q.bool(boolQuery)), this.getIndexNames(context), durationCalculationScript);
        return this.createLimitedGroupByScriptedDurationAggregation(context, boolQuery, durationCalculationScript, minMaxStats, this::createProcessInstanceLimitingFilterQuery);
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createLimitedGroupByScriptedEventDurationAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Script durationCalculationScript) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxNumberRangeForNestedScriptedField(context, Query.of(q -> q.bool(boolQuery)), this.getIndexNames(context), "flowNodeInstances", durationCalculationScript);
        return this.createLimitedGroupByScriptedDurationAggregation(context, boolQuery, durationCalculationScript, minMaxStats, this::createEventLimitingFilterQuery);
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createLimitedGroupByScriptedUserTaskDurationAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Script durationCalculationScript, UserTaskDurationTime userTaskDurationTime) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxNumberRangeForNestedScriptedField(context, Query.of(q -> q.bool(boolQuery)), this.getIndexNames(context), "flowNodeInstances", durationCalculationScript, Query.of(q -> q.bool(ModelElementFilterQueryUtilES.createUserTaskFlowNodeTypeFilter().build())));
        return this.createLimitedGroupByScriptedDurationAggregation(context, boolQuery, durationCalculationScript, minMaxStats, (filterOperator, filterValueInMillis) -> this.createUserTaskLimitingFilterQuery((ComparisonOperator)filterOperator, userTaskDurationTime, (double)filterValueInMillis));
    }

    public List<CompositeCommandResult.GroupByResult> mapGroupByDurationResults(ResponseBody<?> response, Map<String, Aggregate> parentSubAggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        ArrayList<CompositeCommandResult.GroupByResult> durationHistogramData = new ArrayList<CompositeCommandResult.GroupByResult>();
        Optional<HistogramAggregate> histogramAggregationResult = Optional.ofNullable(parentSubAggregations).flatMap(FilterLimitedAggregationUtilES::unwrapFilterLimitedAggregations).map(aggregations -> ((Aggregate)aggregations.get("durationHistogram")).histogram());
        if (histogramAggregationResult.isPresent()) {
            for (HistogramBucket durationBucket : histogramAggregationResult.get().buckets().array()) {
                List<CompositeCommandResult.DistributedByResult> distributions = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)durationBucket.aggregations(), context);
                durationHistogramData.add(CompositeCommandResult.GroupByResult.createGroupByResult(Double.toString(durationBucket.key()), distributions));
            }
        }
        return durationHistogramData;
    }

    private Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createLimitedGroupByScriptedDurationAggregation(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, BoolQuery baseQuery, Script durationCalculationScript, MinMaxStatDto minMaxStats, BiFunction<ComparisonOperator, Double, Query> limitingFilterCreator) {
        double maxValueInMillis;
        if (minMaxStats.isEmpty()) {
            return Optional.empty();
        }
        SingleReportConfigurationDto reportConfigurationDto = context.getReportData().getConfiguration();
        CustomBucketDto customBucketDto = reportConfigurationDto.getCustomBucket();
        double minValueInMillis = this.getMinValueInMillis(minMaxStats, customBucketDto);
        if (minValueInMillis > (maxValueInMillis = minMaxStats.getMax())) {
            return Optional.empty();
        }
        double intervalInMillis = this.getIntervalInMillis(minValueInMillis, maxValueInMillis, customBucketDto);
        Query limitingFilter = Query.of(q -> q.bool(b -> b.filter((Query)limitingFilterCreator.apply(ComparisonOperator.GREATER_THAN_EQUALS, minValueInMillis), new Query[0])));
        Aggregation.Builder.ContainerBuilder builder = NumberHistogramAggregationUtilES.generateHistogramFromScript((String)"durationHistogram", (double)intervalInMillis, (double)minValueInMillis, (Script)durationCalculationScript, (double)maxValueInMillis, this.distributedByInterpreter.createAggregations(context, baseQuery));
        return Optional.of(FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation(limitingFilter, Map.of("durationHistogram", builder)));
    }

    private Query createUserTaskLimitingFilterQuery(ComparisonOperator filterOperator, UserTaskDurationTime userTaskDurationTime, double filterValueInMillis) {
        return this.createLimitingFilterQuery(filterOperator, (long)filterValueInMillis, "flowNodeInstances." + userTaskDurationTime.getDurationFieldName(), "flowNodeInstances.startDate", true);
    }

    private Query createEventLimitingFilterQuery(ComparisonOperator filterOperator, double filterValueInMillis) {
        return this.createLimitingFilterQuery(filterOperator, (long)filterValueInMillis, "flowNodeInstances.totalDurationInMs", "flowNodeInstances.startDate", false);
    }

    private Query createProcessInstanceLimitingFilterQuery(ComparisonOperator filterOperator, double filterValueInMillis) {
        return this.createLimitingFilterQuery(filterOperator, (long)filterValueInMillis, "duration", "startDate", false);
    }

    private Query createLimitingFilterQuery(ComparisonOperator filterOperator, long filterValueInMillis, String durationFieldName, String referenceDateFieldName, boolean includeNull) {
        return Query.of(q -> q.script(s -> s.script(DurationScriptUtilES.getDurationFilterScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), durationFieldName, referenceDateFieldName, DurationFilterDataDto.builder().operator(filterOperator).unit(FILTER_UNIT).value(Long.valueOf(filterValueInMillis)).includeNull(includeNull).build()))));
    }
}

