/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.view.process.duration;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.util.Pair;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.es.report.interpreter.util.DurationScriptUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.AbstractProcessViewMultiAggregationInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Precision;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
@Conditional(value={ElasticSearchCondition.class})
public class ProcessViewUserTaskDurationInterpreterES
extends AbstractProcessViewMultiAggregationInterpreterES {
    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_USER_TASK_DURATION);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return context.getReportData().getConfiguration().getUserTaskDurationTimes().stream().flatMap(userTaskDurationTime -> this.getAggregationStrategies((ProcessReportDataDto)context.getReportData()).stream().map(strategy -> strategy.createAggregationBuilder(userTaskDurationTime.getId(), this.getScriptedAggregationField((UserTaskDurationTime)userTaskDurationTime), new String[0]))).collect(Collectors.toMap(Pair::key, Pair::value));
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        CompositeCommandResult.ViewResult.ViewResultBuilder viewResultBuilder = CompositeCommandResult.ViewResult.builder();
        context.getReportData().getConfiguration().getUserTaskDurationTimes().forEach(userTaskDurationTime -> this.getAggregationStrategies((ProcessReportDataDto)context.getReportData()).forEach(aggregationStrategy -> {
            Double measureResult = aggregationStrategy.getValue(userTaskDurationTime.getId(), aggs);
            if (measureResult != null) {
                measureResult = Precision.round((double)measureResult, (int)0);
            }
            viewResultBuilder.viewMeasure(CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationStrategy.getAggregationType()).userTaskDurationTime((UserTaskDurationTime)userTaskDurationTime).value(measureResult).build());
        }));
        return viewResultBuilder.build();
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        CompositeCommandResult.ViewResult.ViewResultBuilder viewResultBuilder = CompositeCommandResult.ViewResult.builder();
        context.getReportData().getConfiguration().getUserTaskDurationTimes().forEach(userTaskDurationTime -> this.getAggregationStrategies((ProcessReportDataDto)context.getReportData()).forEach(aggregationStrategy -> viewResultBuilder.viewMeasure(CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationStrategy.getAggregationType()).userTaskDurationTime((UserTaskDurationTime)userTaskDurationTime).value(null).build())));
        return viewResultBuilder.build();
    }

    private Script getScriptedAggregationField(UserTaskDurationTime userTaskDurationTime) {
        return DurationScriptUtilES.getUserTaskDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), this.getDurationFieldName(userTaskDurationTime));
    }

    private String getDurationFieldName(UserTaskDurationTime userTaskDurationTime) {
        return "flowNodeInstances." + userTaskDurationTime.getDurationFieldName();
    }
}

