/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.view.process;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.ScriptSortType;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.es.report.interpreter.util.SortUtilsES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.util.RawProcessDataResultDtoMapper;
import io.camunda.optimize.service.db.report.interpreter.view.process.AbstractProcessViewRawDataInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.repository.es.VariableRepositoryES;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessViewRawDataInterpreterES
extends AbstractProcessViewRawDataInterpreter
implements ProcessViewInterpreterES {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessViewRawDataInterpreterES.class);
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;
    private final OptimizeElasticsearchClient esClient;
    private final DefinitionService definitionService;
    private final VariableRepositoryES variableRepository;

    public ProcessViewRawDataInterpreterES(ConfigurationService configurationService, ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, DefinitionService definitionService, VariableRepositoryES variableRepository) {
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
        this.esClient = esClient;
        this.definitionService = definitionService;
        this.variableRepository = variableRepository;
    }

    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_RAW_DATA);
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return CompositeCommandResult.ViewResult.builder().rawData(new ArrayList()).build();
    }

    @Override
    public void adjustSearchRequest(SearchRequest.Builder searchRequestBuilder, BoolQuery.Builder baseQueryBuilder, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        List<String> defKeysToTarget = context.getReportData().getDefinitions().stream().map(ReportDataDefinitionDto::getKey).filter(Objects::nonNull).collect(Collectors.toList());
        Supplier<BoolQuery.Builder> builderSupplier = () -> {
            BoolQuery.Builder variableQuery = new BoolQuery.Builder();
            variableQuery.must(m -> m.bool(b -> baseQueryBuilder));
            return variableQuery;
        };
        Set<String> allVariableNamesForMatchingInstances = this.variableRepository.getVariableNamesForInstancesMatchingQuery(defKeysToTarget, builderSupplier, Collections.emptyMap()).stream().map(ProcessVariableNameResponseDto::getName).collect(Collectors.toSet());
        context.setAllVariablesNames(allVariableNamesForMatchingInstances);
        String sortByField = context.getReportConfiguration().getSorting().flatMap(ReportSortingDto::getBy).orElse("startDate");
        SortOrder sortOrder = context.getReportConfiguration().getSorting().flatMap(ReportSortingDto::getOrder).map(order -> SortOrder.valueOf((String)order.name())).orElse(SortOrder.DESC);
        searchRequestBuilder.source(s -> {
            s.fetch(Boolean.valueOf(true));
            if (!context.isJsonExport()) {
                s.filter(f -> f.excludes("flowNodeInstances", new String[0]));
            }
            return s;
        });
        if (context.isCsvExport()) {
            context.getPagination().ifPresent(pag -> searchRequestBuilder.size(Integer.valueOf(pag.getLimit() > 10000 ? 10000 : pag.getLimit())));
            searchRequestBuilder.scroll(s -> s.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s"));
        } else {
            context.getPagination().ifPresent(pag -> {
                if (pag.getLimit() > 10000) {
                    pag.setLimit(Integer.valueOf(10000));
                }
                searchRequestBuilder.size(pag.getLimit()).from(pag.getOffset());
            });
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("currentTime", LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli());
        params.put("dateFormat", "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        searchRequestBuilder.scriptFields("currentTime", ScriptField.of(f -> f.script(ElasticsearchWriterUtil.createDefaultScriptWithSpecificDtoParams("params.currentTime", params))));
        searchRequestBuilder.scriptFields("numberOfUserTasks", ScriptField.of(f -> f.script(ElasticsearchWriterUtil.createDefaultScript("Optional.ofNullable(params._source.flowNodeInstances)\n  .map(list -> list.stream().filter(item -> item.flowNodeType.equals('userTask')).count())\n  .orElse(0L)\n"))));
        searchRequestBuilder.scriptFields("flowNodeIdsToDurations", ScriptField.of(f -> f.script(ElasticsearchWriterUtil.createDefaultScriptWithSpecificDtoParams("def flowNodeInstanceIdToDuration = new HashMap();\ndef dateFormatter = new SimpleDateFormat(params.dateFormat);\nfor (flowNodeInstance in params._source.flowNodeInstances) {\n  if (flowNodeInstance.totalDurationInMs != null) {\n    if (flowNodeInstanceIdToDuration.containsKey(flowNodeInstance.flowNodeId)) {\n      def currentDuration = flowNodeInstanceIdToDuration.get(flowNodeInstance.flowNodeId);\n      flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, flowNodeInstance.totalDurationInMs + currentDuration)\n    } else {\n      flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, flowNodeInstance.totalDurationInMs)\n    }\n  } else {\n    if (flowNodeInstance.startDate != null) {\n      def duration = params.currentTime - dateFormatter.parse(flowNodeInstance.startDate).getTime();\n      if (flowNodeInstanceIdToDuration.containsKey(flowNodeInstance.flowNodeId)) {\n        def currentDuration = flowNodeInstanceIdToDuration.get(flowNodeInstance.flowNodeId);\n        flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, duration + currentDuration)\n      } else {\n        flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, duration)\n      }\n    }\n  }\n}\nreturn flowNodeInstanceIdToDuration;\n", params))));
        this.addSorting(sortByField, sortOrder, searchRequestBuilder, params);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return Map.of();
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        HashMap<String, Map<String, Long>> processInstanceIdsToFlowNodeIdsAndDurations = new HashMap<String, Map<String, Long>>();
        HashMap<String, Long> instanceIdsToUserTaskCount = new HashMap<String, Long>();
        Function<Hit, ProcessInstanceDto> mappingFunction = hit -> {
            try {
                ProcessInstanceDto processInstance = hit.source() instanceof Map ? (ProcessInstanceDto)this.objectMapper.convertValue(hit.source(), ProcessInstanceDto.class) : (hit.source() instanceof ProcessInstanceDto ? (ProcessInstanceDto)hit.source() : (ProcessInstanceDto)this.objectMapper.readValue(hit.source().toString(), ProcessInstanceDto.class));
                processInstanceIdsToFlowNodeIdsAndDurations.put(processInstance.getProcessInstanceId(), ((Map)((List)((JsonData)hit.fields().get("flowNodeIdsToDurations")).to(List.class)).get(0)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Long.valueOf(e.getValue().toString()))));
                instanceIdsToUserTaskCount.put(processInstance.getProcessInstanceId(), Long.valueOf(((List)((JsonData)hit.fields().get("numberOfUserTasks")).to(List.class)).get(0).toString()));
                if (processInstance.getDuration() == null && processInstance.getStartDate() != null) {
                    Optional sorting = context.getReportConfiguration().getSorting();
                    if (sorting.isPresent() && ((ReportSortingDto)sorting.get()).getBy().isPresent() && "duration".equals(((ReportSortingDto)sorting.get()).getBy().get())) {
                        processInstance.setDuration(Long.valueOf(Math.round(((FieldValue)hit.sort().get(0)).doubleValue())));
                    } else {
                        long currentTime = Long.parseLong(((List)((JsonData)hit.fields().get("currentTime")).to(List.class)).get(0).toString());
                        processInstance.setDuration(Long.valueOf(currentTime - processInstance.getStartDate().toInstant().toEpochMilli()));
                    }
                }
                return processInstance;
            }
            catch (NumberFormatException exception) {
                throw new OptimizeRuntimeException("Error while parsing fields to numbers");
            }
            catch (JsonProcessingException e2) {
                throw new RuntimeException(e2);
            }
        };
        List<ProcessInstanceDto> rawDataProcessInstanceDtos = context.isCsvExport() ? ElasticsearchReaderUtil.retrieveScrollResultsTillLimit(response, ProcessInstanceDto.class, mappingFunction, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds(), context.getPagination().orElse(new PaginationDto()).getLimit()) : ElasticsearchReaderUtil.mapHits(response.hits(), Integer.MAX_VALUE, ProcessInstanceDto.class, mappingFunction);
        RawProcessDataResultDtoMapper rawDataSingleReportResultDtoMapper = new RawProcessDataResultDtoMapper();
        Map<String, String> flowNodeIdsToFlowNodeNames = this.definitionService.fetchDefinitionFlowNodeNamesAndIdsForProcessInstances(rawDataProcessInstanceDtos);
        List<RawDataProcessInstanceDto> rawData = rawDataSingleReportResultDtoMapper.mapFrom(rawDataProcessInstanceDtos, this.objectMapper, context.getAllVariablesNames(), instanceIdsToUserTaskCount, processInstanceIdsToFlowNodeIdsAndDurations, flowNodeIdsToFlowNodeNames, !context.isJsonExport());
        this.addNewVariablesAndDtoFieldsToTableColumnConfig(context, rawData);
        return CompositeCommandResult.ViewResult.builder().rawData(rawData).build();
    }

    private void addSorting(String sortByField, SortOrder sortOrder, SearchRequest.Builder searchRequestBuilder, Map<String, Object> params) {
        if (sortByField.startsWith("variable:")) {
            String variableName = sortByField.substring("variable:".length());
            searchRequestBuilder.sort(SortOptions.of(s -> s.field(f -> f.field(ProcessVariableHelper.getNestedVariableValueField()).nested(n -> n.path("variables").filter(ff -> ff.term(t -> t.field(ProcessVariableHelper.getNestedVariableNameField()).value(variableName)))).order(SortUtilsES.getSortOrder(sortOrder)))), new SortOptions[0]);
        } else if (sortByField.equals("duration")) {
            params.put("duration", "duration");
            params.put("startDate", "startDate");
            Script script = ElasticsearchWriterUtil.createDefaultScriptWithSpecificDtoParams("if (doc[params.duration].size() == 0) {\n  params.currentTime - doc[params.startDate].value.toInstant().toEpochMilli()\n} else {\n   doc[params.duration].value\n}\n", params);
            searchRequestBuilder.sort(s -> s.script(ss -> ss.script(script).type(ScriptSortType.Number).order(SortUtilsES.getSortOrder(sortOrder))));
        } else {
            searchRequestBuilder.sort(s -> s.field(f -> f.field(sortByField).order(SortUtilsES.getSortOrder(sortOrder)).unmappedType(FieldType.Short)));
        }
    }
}

