/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.plan.decision;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.es.builders.OptimizeBoolQueryBuilderES;
import io.camunda.optimize.service.db.es.filter.DecisionQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.report.interpreter.plan.AbstractExecutionPlanInterpreterES;
import io.camunda.optimize.service.db.es.schema.index.DecisionInstanceIndexES;
import io.camunda.optimize.service.db.reader.DecisionDefinitionReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.plan.decision.DecisionExecutionPlanInterpreter;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.util.DefinitionQueryUtilES;
import io.camunda.optimize.service.util.InstanceIndexUtil;

public abstract class AbstractDecisionExecutionPlanInterpreterES
extends AbstractExecutionPlanInterpreterES<DecisionReportDataDto, DecisionExecutionPlan>
implements DecisionExecutionPlanInterpreter {
    protected abstract DecisionDefinitionReader getDecisionDefinitionReader();

    protected abstract DecisionQueryFilterEnhancerES getQueryFilterEnhancer();

    @Override
    public BoolQuery.Builder getBaseQueryBuilder(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        BoolQuery.Builder boolQueryBuilder = this.setupUnfilteredBaseQueryBuilder(context);
        this.getQueryFilterEnhancer().addFilterToQuery(boolQueryBuilder, context.getReportData().getFilter(), context.getFilterContext());
        return boolQueryBuilder;
    }

    @Override
    protected BoolQuery.Builder setupUnfilteredBaseQueryBuilder(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        BoolQuery.Builder definitionFilterQueryBuilder = new OptimizeBoolQueryBuilderES().minimumShouldMatch("1");
        context.getReportData().getDefinitions().stream().findFirst().ifPresent(definitionDto -> definitionFilterQueryBuilder.should(s -> s.bool(DefinitionQueryUtilES.createDefinitionQuery(definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds(), new DecisionInstanceIndexES(definitionDto.getKey()), this.getDecisionDefinitionReader()::getLatestVersionToKey).build())));
        return definitionFilterQueryBuilder;
    }

    @Override
    protected String[] getIndexNames(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return InstanceIndexUtil.getDecisionInstanceIndexAliasName((DecisionReportDataDto)context.getReportData());
    }

    @Override
    protected String[] getMultiIndexAlias() {
        return new String[]{"decision-instance"};
    }
}

