/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.plan;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.ScrollRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.elasticsearch.core.search.TrackHits;
import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationScrollableDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.GroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.ViewInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.plan.ExecutionPlanInterpreter;
import io.camunda.optimize.service.db.report.interpreter.result.ResultInterpreter;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutionPlanInterpreterES<DATA extends SingleReportDataDto, PLAN extends ExecutionPlan>
implements ExecutionPlanInterpreter<DATA, PLAN> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractExecutionPlanInterpreterES.class);

    @Override
    public CommandEvaluationResult<Object> interpret(ExecutionContext<DATA, PLAN> executionContext) {
        ResponseBody<?> response;
        OptimizeSearchRequestBuilderES searchRequest = this.createBaseQuerySearchRequest(executionContext, this.getIndexNames(executionContext));
        try {
            response = this.executeRequests(executionContext, searchRequest, false);
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)e)) {
                if (executionContext.getReportData().getDefinitions().size() > 1) {
                    LOG.info("Could not evaluate report because at least one required instance index {} does not exist. Retrying with index multi alias", Arrays.asList(this.getIndexNames(executionContext)));
                    try {
                        response = this.executeRequests(executionContext, this.createBaseQuerySearchRequest(executionContext, this.getMultiIndexAlias()), true);
                    }
                    catch (RuntimeException ex) {
                        if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)e)) {
                            return this.returnEmptyResult(executionContext);
                        }
                        throw ex;
                    }
                    catch (IOException ex) {
                        throw e;
                    }
                }
                return this.returnEmptyResult(executionContext);
            }
            throw e;
        }
        catch (IOException e) {
            String reason = String.format("Could not evaluate %s report for definitions [%s]", executionContext.getPlan(), executionContext.getReportData().getDefinitions());
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return this.retrieveQueryResult(response, executionContext);
    }

    protected abstract GroupByInterpreterES<DATA, PLAN> getGroupByInterpreter();

    protected abstract ViewInterpreterES<DATA, PLAN> getViewInterpreter();

    protected abstract OptimizeElasticsearchClient getEsClient();

    protected abstract BoolQuery.Builder getBaseQueryBuilder(ExecutionContext<DATA, PLAN> var1);

    protected abstract String[] getIndexNames(ExecutionContext<DATA, PLAN> var1);

    protected abstract String[] getMultiIndexAlias();

    protected abstract BoolQuery.Builder setupUnfilteredBaseQueryBuilder(ExecutionContext<DATA, PLAN> var1);

    private OptimizeSearchRequestBuilderES createBaseQuerySearchRequest(ExecutionContext<DATA, PLAN> executionContext, String ... indexes) {
        Supplier<BoolQuery.Builder> baseQueryBuilderSupplier = () -> this.getBaseQueryBuilder(executionContext);
        OptimizeSearchRequestBuilderES searchBuilder = new OptimizeSearchRequestBuilderES();
        executionContext.getPagination().ifPresent(pagination -> {
            Optional.ofNullable(pagination.getOffset()).ifPresent(arg_0 -> ((OptimizeSearchRequestBuilderES)searchBuilder).from(arg_0));
            Optional.ofNullable(pagination.getLimit()).ifPresent(arg_0 -> ((OptimizeSearchRequestBuilderES)searchBuilder).size(arg_0));
        });
        this.addAggregation(baseQueryBuilderSupplier.get().build(), (SearchRequest.Builder)searchBuilder, executionContext);
        BoolQuery.Builder builder = baseQueryBuilderSupplier.get();
        searchBuilder.optimizeIndex(this.getEsClient(), indexes).source(s -> s.fetch(Boolean.valueOf(false))).trackTotalHits(TrackHits.of(t -> t.enabled(Boolean.valueOf(true))));
        this.getGroupByInterpreter().adjustSearchRequest((SearchRequest.Builder)searchBuilder, builder, executionContext);
        searchBuilder.query(Query.of(q -> q.bool(builder.build())));
        return searchBuilder;
    }

    private void addAggregation(BoolQuery builder, SearchRequest.Builder searchRequestBuilder, ExecutionContext<DATA, PLAN> executionContext) {
        Map<String, Aggregation.Builder.ContainerBuilder> aggregations = this.getGroupByInterpreter().createAggregation(builder, executionContext);
        aggregations.forEach((k, v) -> searchRequestBuilder.aggregations(k, v.build()));
    }

    private ResponseBody<?> executeRequests(ExecutionContext<DATA, PLAN> executionContext, OptimizeSearchRequestBuilderES searchRequest, boolean useMultiInstanceIndexAlias) throws IOException {
        String[] indices = useMultiInstanceIndexAlias ? this.getMultiIndexAlias() : this.getIndexNames(executionContext);
        ResponseBody<?> response = this.executeElasticSearchCommand(executionContext, (SearchRequest.Builder)searchRequest);
        BoolQuery.Builder countQueryBuilder = this.setupUnfilteredBaseQueryBuilder(executionContext);
        executionContext.setUnfilteredTotalInstanceCount(this.getEsClient().count(indices, countQueryBuilder));
        return response;
    }

    private ResponseBody<?> executeElasticSearchCommand(ExecutionContext<DATA, PLAN> executionContext, SearchRequest.Builder searchRequestBuilder) throws IOException {
        SearchResponse response;
        ScrollRequest scrollRequest = null;
        PaginationDto paginationInfo = executionContext.getPagination().orElse(new PaginationDto());
        if (paginationInfo instanceof PaginationScrollableDto) {
            PaginationScrollableDto scrollableDto = (PaginationScrollableDto)paginationInfo;
            String scrollId = scrollableDto.getScrollId();
            Integer timeout = scrollableDto.getScrollTimeout();
            if (scrollId != null && !scrollId.isEmpty()) {
                scrollRequest = ScrollRequest.of(s -> s.scroll(l -> l.time(timeout + "s")).scrollId(scrollId));
            } else {
                searchRequestBuilder.scroll(l -> l.time(timeout + "s"));
            }
            response = scrollRequest != null ? this.getEsClient().scroll(scrollRequest, Object.class) : this.getEsClient().search(searchRequestBuilder.build(), Object.class);
        } else {
            response = this.getEsClient().search(searchRequestBuilder.build());
        }
        return response;
    }

    private CommandEvaluationResult<Object> returnEmptyResult(ExecutionContext<DATA, PLAN> executionContext) {
        LOG.info("Could not evaluate report. Returning empty result instead");
        return ResultInterpreter.interpret(executionContext, new CompositeCommandResult((SingleReportDataDto)executionContext.getReportData(), this.getViewInterpreter().getViewProperty(executionContext), this.getViewInterpreter().createEmptyResult(executionContext).getViewMeasures().stream().findFirst().map(CompositeCommandResult.ViewMeasure::getValue).orElse(null)));
    }

    private CommandEvaluationResult<Object> retrieveQueryResult(ResponseBody<?> response, ExecutionContext<DATA, PLAN> executionContext) {
        CompositeCommandResult result = this.getGroupByInterpreter().retrieveQueryResult(response, executionContext);
        CommandEvaluationResult reportResult = ResultInterpreter.interpret(executionContext, result);
        reportResult.setInstanceCount(response.hits().total().value());
        reportResult.setInstanceCountWithoutFilters(executionContext.getUnfilteredTotalInstanceCount());
        executionContext.getPagination().ifPresent(plainPagination -> {
            PaginationScrollableDto scrollablePagination = PaginationScrollableDto.fromPaginationDto((PaginationDto)plainPagination);
            scrollablePagination.setScrollId(response.scrollId());
            reportResult.setPagination((PaginationDto)scrollablePagination);
        });
        return reportResult;
    }
}

