/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.none;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.SingleBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.IncidentFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.ProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessIncidentGroupByNoneInterpreterES
extends AbstractProcessGroupByInterpreterES
implements ProcessGroupByInterpreterES {
    private static final String NESTED_INCIDENT_AGGREGATION = "incidentAggregation";
    private static final String FILTERED_INCIDENT_AGGREGATION = "filteredIncidentAggregation";
    private final ProcessViewInterpreterFacadeES viewInterpreter;
    private final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    private final DefinitionService definitionService;

    public ProcessIncidentGroupByNoneInterpreterES(ProcessViewInterpreterFacadeES viewInterpreter, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, DefinitionService definitionService) {
        this.viewInterpreter = viewInterpreter;
        this.distributedByInterpreter = distributedByInterpreter;
        this.definitionService = definitionService;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_INCIDENT_GROUP_BY_NONE);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().nested(n -> n.path("incidents"));
        builder.aggregations(FILTERED_INCIDENT_AGGREGATION, Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder filter = a.filter(f -> f.bool(IncidentFilterQueryUtilES.createIncidentAggregationFilter((ProcessReportDataDto)context.getReportData(), this.definitionService).build()));
            this.getDistributedByInterpreter().createAggregations(context, boolQuery).forEach((k, v) -> filter.aggregations(k, v.build()));
            return filter;
        }));
        return Map.of(NESTED_INCIDENT_AGGREGATION, builder);
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        this.getNestedIncidentsAggregation(response).ifPresent(nestedIncidents -> {
            List<CompositeCommandResult.DistributedByResult> distributions = this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)nestedIncidents.aggregations(), context);
            CompositeCommandResult.GroupByResult groupByResult = CompositeCommandResult.GroupByResult.createGroupByNone(distributions);
            compositeCommandResult.setGroup(groupByResult);
        });
    }

    private Optional<FilterAggregate> getNestedIncidentsAggregation(ResponseBody<?> response) {
        return this.getFilteredIncidentsAggregation(response).map(SingleBucketAggregateBase::aggregations).map(aggs -> ((Aggregate)aggs.get(FILTERED_INCIDENT_AGGREGATION)).filter());
    }

    private Optional<NestedAggregate> getFilteredIncidentsAggregation(ResponseBody<?> response) {
        return Optional.ofNullable(response.aggregations()).map(aggs -> ((Aggregate)aggs.get(NESTED_INCIDENT_AGGREGATION)).nested());
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }
}

