/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.model;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.util.NamedValue;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.FlowNodeDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.distributedby.process.model.ProcessDistributedByModelElementInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractProcessDistributedByModelElementInterpreterES
extends AbstractProcessDistributedByInterpreterES {
    private static final String MODEL_ELEMENT_ID_TERMS_AGGREGATION = "modelElement";

    protected abstract ConfigurationService getConfigurationService();

    protected abstract DefinitionService getDefinitionService();

    protected abstract ProcessDistributedByModelElementInterpreterHelper getHelper();

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, BoolQuery baseQueryBuilder) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().terms(t -> t.size(this.getConfigurationService().getElasticSearchConfiguration().getAggregationBucketLimit()).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0]).field(this.getModelElementIdPath()));
        this.getViewInterpreter().createAggregations(context).forEach((k, v) -> builder.aggregations(k, v.build()));
        return Map.of(MODEL_ELEMENT_ID_TERMS_AGGREGATION, builder);
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        StringTermsAggregate byModelElementAggregation = aggregations.get(MODEL_ELEMENT_ID_TERMS_AGGREGATION).sterms();
        Map<String, FlowNodeDataDto> modelElementData = this.getHelper().getModelElementData(context.getReportData(), this::extractModelElementData);
        ArrayList<CompositeCommandResult.DistributedByResult> distributedByModelElements = new ArrayList<CompositeCommandResult.DistributedByResult>();
        for (StringTermsBucket modelElementBucket : byModelElementAggregation.buckets().array()) {
            CompositeCommandResult.ViewResult viewResult = this.getViewInterpreter().retrieveResult(response, modelElementBucket.aggregations(), context);
            String modelElementKey = modelElementBucket.key().stringValue();
            if (!modelElementData.containsKey(modelElementKey)) continue;
            String label = modelElementData.get(modelElementKey).getName();
            distributedByModelElements.add(CompositeCommandResult.DistributedByResult.createDistributedByResult(modelElementKey, label, viewResult));
            modelElementData.remove(modelElementKey);
        }
        distributedByModelElements.addAll(this.getHelper().missingDistributions(modelElementData, this.getViewInterpreter(), context));
        return distributedByModelElements;
    }

    protected abstract String getModelElementIdPath();

    protected abstract Map<String, FlowNodeDataDto> extractModelElementData(DefinitionOptimizeResponseDto var1);
}

