/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.DefinitionReaderES;
import io.camunda.optimize.service.db.reader.DefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessDefinitionReaderES
implements ProcessDefinitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionReaderES.class);
    private final DefinitionReaderES definitionReader;
    private final OptimizeElasticsearchClient esClient;

    public ProcessDefinitionReaderES(DefinitionReaderES definitionReader, OptimizeElasticsearchClient esClient) {
        this.definitionReader = definitionReader;
        this.esClient = esClient;
    }

    @Override
    public Optional<ProcessDefinitionOptimizeDto> getProcessDefinition(String definitionId) {
        BoolQuery.Builder query = new BoolQuery.Builder();
        query.must(m -> m.matchAll(l -> l));
        query.must(t -> t.terms(l -> l.field("id").terms(tt -> tt.value(List.of(FieldValue.of((String)definitionId))))));
        return this.definitionReader.getDefinitions(DefinitionType.PROCESS, query, true).stream().findFirst().map(ProcessDefinitionOptimizeDto.class::cast);
    }

    @Override
    public Set<String> getAllNonOnboardedProcessDefinitionKeys() {
        SearchResponse searchResponse;
        String defKeyAgg = "keyAgg";
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"process-definition"}).query(q -> q.bool(b -> b.must(m -> m.terms(t -> t.field("onboarded").terms(tt -> tt.value(List.of(FieldValue.of((boolean)false)))))).must(m -> m.term(t -> t.field("deleted").value(false))).should(ss -> ss.exists(e -> e.field("bpmn20Xml"))))).aggregations("keyAgg", Aggregation.of(a -> a.terms(t -> t.field("key")))).source(o -> o.fetch(Boolean.valueOf(false))).size(Integer.valueOf(10000)));
        try {
            searchResponse = this.esClient.search(searchRequest, Object.class);
        }
        catch (IOException e2) {
            String reason = "Was not able to fetch non-onboarded process definition keys.";
            LOG.error("Was not able to fetch non-onboarded process definition keys.", (Throwable)e2);
            throw new OptimizeRuntimeException("Was not able to fetch non-onboarded process definition keys.", (Throwable)e2);
        }
        StringTermsAggregate definitionKeyTerms = ((Aggregate)searchResponse.aggregations().get("keyAgg")).sterms();
        return definitionKeyTerms.buckets().array().stream().map(e -> e.key().stringValue()).collect(Collectors.toSet());
    }

    @Override
    public DefinitionReader getDefinitionReader() {
        return this.definitionReader;
    }
}

