/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSource;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.util.ObjectBuilder;
import com.google.common.collect.ImmutableList;
import io.camunda.optimize.service.db.es.ElasticsearchCompositeAggregationScroller;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.reader.AssigneeAndCandidateGroupsReader;
import io.camunda.optimize.service.util.DefinitionQueryUtilES;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class AssigneeAndCandidateGroupsReaderES
implements AssigneeAndCandidateGroupsReader {
    private static final Logger LOG = LoggerFactory.getLogger(AssigneeAndCandidateGroupsReaderES.class);
    private final OptimizeElasticsearchClient esClient;

    public AssigneeAndCandidateGroupsReaderES(OptimizeElasticsearchClient esClient) {
        this.esClient = esClient;
    }

    @Override
    public void consumeAssigneesInBatches(String engineAlias, Consumer<List<String>> assigneeBatchConsumer, int batchSize) {
        if (engineAlias == null) {
            throw new IllegalArgumentException("engineAlias cannot be null");
        }
        if (assigneeBatchConsumer == null) {
            throw new IllegalArgumentException("assigneeBatchConsumer cannot be null");
        }
        this.consumeUserTaskFieldTermsInBatches(Query.of(q -> q.term(t -> t.field("dataSource.name").value(engineAlias))), "assignee", assigneeBatchConsumer, batchSize);
    }

    @Override
    public void consumeCandidateGroupsInBatches(String engineAlias, Consumer<List<String>> candidateGroupBatchConsumer, int batchSize) {
        if (engineAlias == null) {
            throw new IllegalArgumentException("engineAlias cannot be null");
        }
        if (candidateGroupBatchConsumer == null) {
            throw new IllegalArgumentException("candidateGroupBatchConsumer cannot be null");
        }
        this.consumeUserTaskFieldTermsInBatches(Query.of(q -> q.term(t -> t.field("dataSource.name").value(engineAlias))), "candidateGroups", candidateGroupBatchConsumer, batchSize);
    }

    @Override
    public Set<String> getAssigneeIdsForProcess(Map<String, Set<String>> definitionKeyToTenantsMap) {
        return this.getUserTaskFieldTerms("assignee", definitionKeyToTenantsMap);
    }

    @Override
    public Set<String> getCandidateGroupIdsForProcess(Map<String, Set<String>> definitionKeyToTenantsMap) {
        return this.getUserTaskFieldTerms("candidateGroups", definitionKeyToTenantsMap);
    }

    @Override
    public Set<String> getUserTaskFieldTerms(String userTaskFieldName, Map<String, Set<String>> definitionKeyToTenantsMap) {
        LOG.debug("Fetching {} for process definition with key and tenants [{}]", (Object)userTaskFieldName, definitionKeyToTenantsMap);
        HashSet<String> result = new HashSet<String>();
        if (!definitionKeyToTenantsMap.isEmpty()) {
            Query definitionQuery = DefinitionQueryUtilES.createDefinitionQuery(definitionKeyToTenantsMap, "processDefinitionKey", "tenantId");
            this.consumeUserTaskFieldTermsInBatches(definitionQuery, userTaskFieldName, result::addAll);
        }
        return result;
    }

    @Override
    public void consumeUserTaskFieldTermsInBatches(String indexName, String termField, String termValue, String userTaskFieldName, Consumer<List<String>> termBatchConsumer, int batchSize) {
        this.consumeUserTaskFieldTermsInBatches(indexName, Query.of(q -> q.term(t -> t.field(termField).value(termValue))), userTaskFieldName, termBatchConsumer, batchSize);
    }

    private void consumeUserTaskFieldTermsInBatches(Query filterQuery, String fieldName, Consumer<List<String>> termBatchConsumer) {
        this.consumeUserTaskFieldTermsInBatches("process-instance", filterQuery, fieldName, termBatchConsumer, 10000);
    }

    private void consumeUserTaskFieldTermsInBatches(Query filterQuery, String fieldName, Consumer<List<String>> termBatchConsumer, int batchSize) {
        this.consumeUserTaskFieldTermsInBatches("process-instance", filterQuery, fieldName, termBatchConsumer, batchSize);
    }

    public void consumeUserTaskFieldTermsInBatches(String indexName, Query filterQuery, String fieldName, Consumer<List<String>> termBatchConsumer, int batchSize) {
        boolean hasPage;
        int resolvedBatchSize = Math.min(batchSize, 10000);
        Function<Map<String, FieldValue>, SearchRequest> aggregationRequestWithAfterKeys = map -> OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{indexName}).query(filterQuery).size(Integer.valueOf(0)).aggregations("userTasks", Aggregation.of(a -> a.nested(NestedAggregation.of(n -> n.path("flowNodeInstances"))).aggregations("composite", Aggregation.of(aa -> aa.composite(CompositeAggregation.of(c -> {
            c.sources((List)ImmutableList.of(Map.of("userTaskFieldTerms", CompositeAggregationSource.of(cc -> cc.terms(CompositeTermsAggregation.of(ct -> (ObjectBuilder)((CompositeTermsAggregation.Builder)((CompositeTermsAggregation.Builder)ct.field(this.getUserTaskFieldPath(fieldName))).missingBucket(Boolean.valueOf(false))).order(SortOrder.Asc))))))).size(Integer.valueOf(resolvedBatchSize));
            if (map != null) {
                c.after(map);
            }
            return c;
        })))))));
        ArrayList termsBatch = new ArrayList();
        ElasticsearchCompositeAggregationScroller compositeAggregationScroller = ElasticsearchCompositeAggregationScroller.create().setEsClient(this.esClient).setSearchRequest(aggregationRequestWithAfterKeys.apply(null)).setFunction(aggregationRequestWithAfterKeys).setPathToAggregation("userTasks", "composite").setCompositeBucketConsumer(bucket -> termsBatch.add(((FieldValue)bucket.key().get("userTaskFieldTerms")).stringValue()));
        do {
            hasPage = compositeAggregationScroller.consumePage();
            termBatchConsumer.accept(termsBatch);
            termsBatch.clear();
        } while (hasPage);
    }
}

