/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter.util;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.flownode.FlowNodeDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.MembershipFilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.AssigneeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CandidateGroupFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedOrCanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeDurationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ProcessFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutedFlowNodeFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.FlowNodeDurationFiltersDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.IdentityLinkFilterDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.DateFilterQueryUtilES;
import io.camunda.optimize.service.db.es.filter.util.NestedDefinitionQueryBuilderES;
import io.camunda.optimize.service.db.es.report.interpreter.util.DurationScriptUtilES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.report.filter.util.ModelElementFilterQueryUtil;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.function.TriFunction;

public final class ModelElementFilterQueryUtilES {
    private static final Map<Class<? extends ProcessFilterDto<?>>, Function<BoolQuery.Builder, BoolQuery.Builder>> FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES = Map.of(RunningFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilES::createRunningFlowNodesOnlyFilterQuery, CompletedFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilES::createCompletedFlowNodesOnlyFilterQuery, CompletedOrCanceledFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilES::createCompletedOrCanceledFlowNodesOnlyFilterQuery, CanceledFlowNodesOnlyFilterDto.class, ModelElementFilterQueryUtilES::createCanceledFlowNodesOnlyFilterQuery);
    private static final Map<Class<? extends ProcessFilterDto<?>>, TriFunction<FlowNodeDateFilterDataDto<?>, ZoneId, BoolQuery.Builder, BoolQuery.Builder>> FLOW_NODE_DATE_VIEW_FILTER_INSTANCE_QUERIES = Map.of(FlowNodeStartDateFilterDto.class, ModelElementFilterQueryUtilES::createFlowNodeStartDateFilterQuery, FlowNodeEndDateFilterDto.class, ModelElementFilterQueryUtilES::createFlowNodeEndDateFilterQuery);
    private static final NestedDefinitionQueryBuilderES NESTED_DEFINITION_QUERY_BUILDER = new NestedDefinitionQueryBuilderES("flowNodeInstances", "definitionKey", "definitionVersion", "tenantId");

    private ModelElementFilterQueryUtilES() {
    }

    public static Optional<NestedQuery.Builder> addInstanceFilterForRelevantViewLevelFilters(List<ProcessFilterDto<?>> filters, FilterContext filterContext) {
        List<ProcessFilterDto<?>> viewLevelFiltersForInstanceMatch = ModelElementFilterQueryUtil.getViewLevelFiltersForInstanceMatch(filters);
        if (!viewLevelFiltersForInstanceMatch.isEmpty()) {
            BoolQuery.Builder viewFilterInstanceQuery = ModelElementFilterQueryUtilES.createFlowNodeTypeFilterQuery(filterContext.isUserTaskReport());
            viewLevelFiltersForInstanceMatch.forEach(filter -> {
                if (filter instanceof FlowNodeDurationFilterDto) {
                    FlowNodeDurationFiltersDataDto filterData = (FlowNodeDurationFiltersDataDto)filter.getData();
                    ModelElementFilterQueryUtilES.createFlowNodeDurationFilterQuery(filterData, viewFilterInstanceQuery);
                } else if (filter instanceof CandidateGroupFilterDto) {
                    IdentityLinkFilterDataDto filterData = (IdentityLinkFilterDataDto)filter.getData();
                    ModelElementFilterQueryUtilES.createCandidateGroupFilterQuery(filterData, viewFilterInstanceQuery);
                } else if (filter instanceof AssigneeFilterDto) {
                    IdentityLinkFilterDataDto filterData = (IdentityLinkFilterDataDto)filter.getData();
                    ModelElementFilterQueryUtilES.createAssigneeFilterQuery(filterData, viewFilterInstanceQuery);
                } else if (filter instanceof ExecutedFlowNodeFilterDto) {
                    ExecutedFlowNodeFilterDataDto filterData = (ExecutedFlowNodeFilterDataDto)filter.getData();
                    ModelElementFilterQueryUtilES.createExecutedFlowNodeFilterQuery(filterData, viewFilterInstanceQuery);
                } else if (FLOW_NODE_DATE_VIEW_FILTER_INSTANCE_QUERIES.containsKey(filter.getClass())) {
                    FLOW_NODE_DATE_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass()).apply((Object)((FlowNodeDateFilterDataDto)filter.getData()), (Object)filterContext.getTimezone(), (Object)viewFilterInstanceQuery);
                } else {
                    FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass()).apply(viewFilterInstanceQuery);
                }
            });
            NestedQuery.Builder builder = new NestedQuery.Builder();
            builder.path("flowNodeInstances").scoreMode(ChildScoreMode.None).query(q -> q.bool(viewFilterInstanceQuery.build()));
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    public static BoolQuery.Builder createModelElementAggregationFilter(ProcessReportDataDto reportData, FilterContext filterContext, DefinitionService definitionService) {
        BoolQuery.Builder filterBoolQuery = ModelElementFilterQueryUtilES.createFlowNodeTypeFilterQuery(reportData).minimumShouldMatch("1");
        Map filtersByDefinition = reportData.groupFiltersByDefinitionIdentifier();
        reportData.getDefinitions().forEach(definitionDto -> {
            BoolQuery.Builder flowNodeDefinitionQuery = new BoolQuery.Builder();
            flowNodeDefinitionQuery.must(m -> NESTED_DEFINITION_QUERY_BUILDER.createNestedDocDefinitionQuery(definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds(), definitionService));
            ModelElementFilterQueryUtilES.addModelElementFilters(flowNodeDefinitionQuery, filterContext, filtersByDefinition.getOrDefault(definitionDto.getIdentifier(), Collections.emptyList()));
            filterBoolQuery.should(s -> s.bool(flowNodeDefinitionQuery.build()));
        });
        ModelElementFilterQueryUtilES.addModelElementFilters(filterBoolQuery, filterContext, filtersByDefinition.getOrDefault("all", Collections.emptyList()));
        return filterBoolQuery;
    }

    private static void addModelElementFilters(BoolQuery.Builder filterBoolQuery, FilterContext filterContext, List<ProcessFilterDto<?>> filters) {
        if (filters.isEmpty()) {
            return;
        }
        ModelElementFilterQueryUtilES.addFlowNodeStatusFilter(filterBoolQuery, filters);
        ModelElementFilterQueryUtilES.addFlowNodeDurationFilter(filterBoolQuery, filters);
        ModelElementFilterQueryUtilES.addFlowNodeIdFilter(filterBoolQuery, filters);
        ModelElementFilterQueryUtilES.addFlowNodeStartDateFilter(filterBoolQuery, filterContext.getTimezone(), filters);
        ModelElementFilterQueryUtilES.addFlowNodeEndDateFilter(filterBoolQuery, filterContext.getTimezone(), filters);
        ModelElementFilterQueryUtilES.addAssigneeFilter(filterBoolQuery, filters);
        ModelElementFilterQueryUtilES.addCandidateGroupFilter(filterBoolQuery, filters);
    }

    public static BoolQuery.Builder createUserTaskFlowNodeTypeFilter() {
        return new BoolQuery.Builder().must(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeType")).value("userTask")));
    }

    public static BoolQuery.Builder createInclusiveFlowNodeIdFilterQuery(ProcessReportDataDto reportDataDto, Set<String> flowNodeIds, FilterContext filterContext, DefinitionService definitionService) {
        return ModelElementFilterQueryUtilES.createExecutedFlowNodeFilterQuery(ModelElementFilterQueryUtilES.createModelElementAggregationFilter(reportDataDto, filterContext, definitionService), ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeId"), new ArrayList<String>(flowNodeIds), MembershipFilterOperator.IN);
    }

    public static BoolQuery.Builder createExecutedFlowNodeFilterQuery(ExecutedFlowNodeFilterDataDto executedFlowNodeFilterData, BoolQuery.Builder boolQuery) {
        return ModelElementFilterQueryUtilES.createExecutedFlowNodeFilterQuery(boolQuery, ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeId"), executedFlowNodeFilterData.getValues(), executedFlowNodeFilterData.getOperator());
    }

    public static BoolQuery.Builder createExecutedFlowNodeFilterQuery(ExecutedFlowNodeFilterDataDto executedFlowNodeFilterData, String nestedFieldReference, BoolQuery.Builder boolQuery) {
        return ModelElementFilterQueryUtilES.createExecutedFlowNodeFilterQuery(boolQuery, nestedFieldReference, executedFlowNodeFilterData.getValues(), executedFlowNodeFilterData.getOperator());
    }

    public static BoolQuery.Builder createExecutedFlowNodeFilterQuery(BoolQuery.Builder boolQuery, String nestedFieldReference, List<String> flowNodeIds, MembershipFilterOperator operator) {
        TermsQuery.Builder builder = new TermsQuery.Builder();
        builder.field(nestedFieldReference);
        builder.terms(tt -> tt.value(flowNodeIds.stream().map(FieldValue::of).toList()));
        if (MembershipFilterOperator.IN.equals((Object)operator)) {
            boolQuery.filter(f -> f.terms(builder.build()));
        } else {
            boolQuery.filter(f -> f.bool(b -> b.mustNot(m -> m.terms(builder.build()))));
        }
        return boolQuery;
    }

    public static BoolQuery.Builder createFlowNodeDurationFilterQuery(FlowNodeDurationFiltersDataDto durationFilterData) {
        return ModelElementFilterQueryUtilES.createFlowNodeDurationFilterQuery(durationFilterData, new BoolQuery.Builder());
    }

    public static BoolQuery.Builder createRunningFlowNodesOnlyFilterQuery(BoolQuery.Builder boolQuery) {
        boolQuery.mustNot(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeType")).value("multiInstanceBody"))).mustNot(m -> m.exists(e -> e.field(ModelElementFilterQueryUtilES.nestedFieldReference("endDate"))));
        return boolQuery;
    }

    public static BoolQuery.Builder createCompletedFlowNodesOnlyFilterQuery(BoolQuery.Builder boolQuery) {
        boolQuery.mustNot(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeType")).value("multiInstanceBody"))).must(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("canceled")).value(false))).must(m -> m.exists(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("endDate"))));
        return boolQuery;
    }

    public static BoolQuery.Builder createCanceledFlowNodesOnlyFilterQuery(BoolQuery.Builder boolQuery) {
        boolQuery.mustNot(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeType")).value("multiInstanceBody"))).must(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("canceled")).value(true)));
        return boolQuery;
    }

    public static BoolQuery.Builder createCompletedOrCanceledFlowNodesOnlyFilterQuery(BoolQuery.Builder builder) {
        builder.mustNot(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeType")).value("multiInstanceBody"))).must(m -> m.exists(e -> e.field(ModelElementFilterQueryUtilES.nestedFieldReference("endDate"))));
        return builder;
    }

    public static BoolQuery.Builder createFlowNodeStartDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone) {
        return ModelElementFilterQueryUtilES.createFlowNodeStartDateFilterQuery(filterData, timezone, new BoolQuery.Builder());
    }

    public static BoolQuery.Builder createFlowNodeStartDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilES.createFlowNodeDateFilterQuery(filterData, timezone, queryBuilder, ModelElementFilterQueryUtilES.nestedFieldReference("startDate"));
    }

    public static BoolQuery.Builder createFlowNodeEndDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone) {
        return ModelElementFilterQueryUtilES.createFlowNodeEndDateFilterQuery(filterData, timezone, new BoolQuery.Builder());
    }

    public static BoolQuery.Builder createFlowNodeEndDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilES.createFlowNodeDateFilterQuery(filterData, timezone, queryBuilder, ModelElementFilterQueryUtilES.nestedFieldReference("endDate"));
    }

    private static BoolQuery.Builder createFlowNodeDateFilterQuery(FlowNodeDateFilterDataDto<?> filterData, ZoneId timezone, BoolQuery.Builder queryBuilder, String nestedDateField) {
        Optional<RangeQuery> rangeQuery = DateFilterQueryUtilES.createRangeQuery(filterData, nestedDateField, timezone);
        rangeQuery.ifPresent(dateRangeQuery -> {
            if (CollectionUtils.isEmpty((Collection)filterData.getFlowNodeIds())) {
                queryBuilder.filter(f -> f.range(dateRangeQuery));
            } else {
                queryBuilder.minimumShouldMatch("1");
                filterData.getFlowNodeIds().forEach(flowNodeId -> queryBuilder.should(s -> s.bool(b -> b.must(m -> m.terms(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeId")).terms(tt -> tt.value(List.of(FieldValue.of((String)flowNodeId)))))).must(m -> m.range(dateRangeQuery)))));
            }
        });
        return queryBuilder;
    }

    public static BoolQuery.Builder createAssigneeFilterQuery(IdentityLinkFilterDataDto assigneeFilter) {
        return ModelElementFilterQueryUtilES.createAssigneeFilterQuery(assigneeFilter, new BoolQuery.Builder());
    }

    private static BoolQuery.Builder createAssigneeFilterQuery(IdentityLinkFilterDataDto assigneeFilter, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilES.createIdentityLinkFilterQuery(assigneeFilter, "assignee", queryBuilder);
    }

    public static BoolQuery.Builder createCandidateGroupFilterQuery(IdentityLinkFilterDataDto candidateGroupFilter) {
        return ModelElementFilterQueryUtilES.createCandidateGroupFilterQuery(candidateGroupFilter, new BoolQuery.Builder());
    }

    private static BoolQuery.Builder createCandidateGroupFilterQuery(IdentityLinkFilterDataDto candidateGroupFilter, BoolQuery.Builder queryBuilder) {
        return ModelElementFilterQueryUtilES.createIdentityLinkFilterQuery(candidateGroupFilter, "candidateGroups", queryBuilder);
    }

    private static BoolQuery.Builder createIdentityLinkFilterQuery(IdentityLinkFilterDataDto identityFilter, String valueField, BoolQuery.Builder queryBuilder) {
        if (CollectionUtils.isEmpty((Collection)identityFilter.getValues())) {
            throw new OptimizeValidationException("Filter values are not allowed to be empty.");
        }
        AtomicBoolean includeNull = new AtomicBoolean(false);
        Set nonNullValues = identityFilter.getValues().stream().peek(value -> {
            if (value == null) {
                includeNull.set(true);
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        queryBuilder.must(Query.of(q -> q.bool(ModelElementFilterQueryUtilES.createUserTaskFlowNodeTypeFilter().build())), new Query[0]);
        BoolQuery.Builder identityQuery = new BoolQuery.Builder().minimumShouldMatch("1");
        if (!nonNullValues.isEmpty()) {
            identityQuery.should(s -> s.terms(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference(valueField)).terms(tt -> tt.value(nonNullValues.stream().map(FieldValue::of).toList()))));
        }
        if (includeNull.get()) {
            identityQuery.should(s -> s.bool(b -> b.mustNot(e -> e.exists(ee -> ee.field(ModelElementFilterQueryUtilES.nestedFieldReference(valueField))))));
        }
        if (MembershipFilterOperator.NOT_IN.equals((Object)identityFilter.getOperator())) {
            queryBuilder.mustNot(m -> m.bool(identityQuery.build()));
        } else {
            queryBuilder.must(m -> m.bool(identityQuery.build()));
        }
        return queryBuilder;
    }

    private static BoolQuery.Builder createFlowNodeDurationFilterQuery(FlowNodeDurationFiltersDataDto durationFilterData, BoolQuery.Builder queryBuilder) {
        queryBuilder.minimumShouldMatch("1");
        durationFilterData.forEach((flowNodeId, durationFilter) -> queryBuilder.should(s -> s.bool(b -> b.must(m -> m.term(t -> t.field(ModelElementFilterQueryUtilES.nestedFieldReference("flowNodeId")).value(flowNodeId))).must(m -> m.script(sc -> sc.script(DurationScriptUtilES.getDurationFilterScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), ModelElementFilterQueryUtilES.nestedFieldReference("totalDurationInMs"), ModelElementFilterQueryUtilES.nestedFieldReference("startDate"), durationFilter)))))));
        return queryBuilder;
    }

    private static void addFlowNodeStatusFilter(BoolQuery.Builder boolQuery, List<ProcessFilterDto<?>> filters) {
        filters.stream().filter(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel())).filter(filter -> FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES.containsKey(filter.getClass())).forEach(filter -> boolQuery.filter(f -> f.bool(FLOW_NODE_STATUS_VIEW_FILTER_INSTANCE_QUERIES.get(filter.getClass()).apply(new BoolQuery.Builder()).build())));
    }

    private static void addFlowNodeDurationFilter(BoolQuery.Builder boolQuery, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilES.findAllViewLevelFiltersOfType(filters, FlowNodeDurationFilterDto.class).map(ProcessFilterDto::getData).forEach(durationFilterData -> boolQuery.filter(f -> f.bool(ModelElementFilterQueryUtilES.createFlowNodeDurationFilterQuery(durationFilterData).build())));
    }

    private static void addAssigneeFilter(BoolQuery.Builder userTaskFilterBoolQuery, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilES.findAllViewLevelFiltersOfType(filters, AssigneeFilterDto.class).map(ProcessFilterDto::getData).forEach(assigneeFilterData -> userTaskFilterBoolQuery.filter(f -> f.bool(ModelElementFilterQueryUtilES.createAssigneeFilterQuery(assigneeFilterData, new BoolQuery.Builder()).build())));
    }

    private static void addCandidateGroupFilter(BoolQuery.Builder userTaskFilterBoolQuery, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilES.findAllViewLevelFiltersOfType(filters, CandidateGroupFilterDto.class).map(ProcessFilterDto::getData).forEach(candidateFilterData -> userTaskFilterBoolQuery.filter(f -> f.bool(ModelElementFilterQueryUtilES.createCandidateGroupFilterQuery(candidateFilterData, new BoolQuery.Builder()).build())));
    }

    private static void addFlowNodeIdFilter(BoolQuery.Builder boolQuery, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilES.findAllViewLevelFiltersOfType(filters, ExecutedFlowNodeFilterDto.class).map(ProcessFilterDto::getData).forEach(executedFlowNodeFilterData -> boolQuery.filter(f -> f.bool(ModelElementFilterQueryUtilES.createExecutedFlowNodeFilterQuery(executedFlowNodeFilterData, new BoolQuery.Builder()).build())));
    }

    private static void addFlowNodeStartDateFilter(BoolQuery.Builder boolQuery, ZoneId timezone, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilES.findAllViewLevelFiltersOfType(filters, FlowNodeStartDateFilterDto.class).map(ProcessFilterDto::getData).forEach(flowNodeStartDateFilterData -> ModelElementFilterQueryUtilES.createFlowNodeStartDateFilterQuery(flowNodeStartDateFilterData, timezone, boolQuery));
    }

    private static void addFlowNodeEndDateFilter(BoolQuery.Builder boolQuery, ZoneId timezone, List<ProcessFilterDto<?>> filters) {
        ModelElementFilterQueryUtilES.findAllViewLevelFiltersOfType(filters, FlowNodeEndDateFilterDto.class).map(ProcessFilterDto::getData).forEach(flowNodeEndDateFilterData -> ModelElementFilterQueryUtilES.createFlowNodeEndDateFilterQuery(flowNodeEndDateFilterData, timezone, boolQuery));
    }

    private static <T extends ProcessFilterDto<?>> Stream<T> findAllViewLevelFiltersOfType(List<ProcessFilterDto<?>> filters, Class<T> filterClass) {
        return filters.stream().filter(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel())).filter(filterClass::isInstance).map(filterClass::cast);
    }

    private static String nestedFieldReference(String fieldName) {
        return "flowNodeInstances." + fieldName;
    }

    private static BoolQuery.Builder createFlowNodeTypeFilterQuery(ProcessReportDataDto reportDataDto) {
        return ModelElementFilterQueryUtilES.createFlowNodeTypeFilterQuery(reportDataDto.isUserTaskReport());
    }

    private static BoolQuery.Builder createFlowNodeTypeFilterQuery(boolean isUserTaskReport) {
        return isUserTaskReport ? ModelElementFilterQueryUtilES.createUserTaskFlowNodeTypeFilter() : new BoolQuery.Builder();
    }
}

