/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.dashboard;

import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardInstanceStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.data.DashboardDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardReportTileDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardTileType;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DimensionDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.PositionDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.SingleReportConfigurationDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.RollingDateFilterStartDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.instance.RollingDateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessVisualization;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.ProcessDistributedByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.ProcessReportDistributedByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.util.ProcessFilterBuilder;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.NoneGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.ProcessGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.StartDateGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.DateGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewEntity;
import io.camunda.optimize.service.db.writer.DashboardWriter;
import io.camunda.optimize.service.db.writer.ReportWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ManagementDashboardService {
    public static final String MANAGEMENT_DASHBOARD_LOCALIZATION_CODE = "dashboardName";
    public static final String MANAGEMENT_DASHBOARD_ID = "management-dashboard";
    public static final String CURRENTLY_IN_PROGRESS_NAME_LOCALIZATION_CODE = "instancesCurrentlyInProgressName";
    public static final String CURRENTLY_IN_PROGRESS_DESCRIPTION_LOCALIZATION_CODE = "instancesCurrentlyInProgressDescription";
    public static final String STARTED_IN_LAST_SIX_MONTHS_NAME_LOCALIZATION_CODE = "instancesStartedInLastSixMonthsName";
    public static final String STARTED_IN_LAST_SIX_MONTHS_DESCRIPTION_LOCALIZATION_CODE = "instancesStartedInLastSixMonthsDescription";
    public static final String ENDED_IN_LAST_SIX_MONTHS_NAME_LOCALIZATION_CODE = "instancesEndedInLastSixMonthsName";
    public static final String ENDED_IN_LAST_SIX_MONTHS_DESCRIPTION_LOCALIZATION_CODE = "instancesEndedInLastSixMonthsDescription";
    private static final Logger LOG = LoggerFactory.getLogger(ManagementDashboardService.class);
    private final DashboardWriter dashboardWriter;
    private final ReportWriter reportWriter;
    private final ConfigurationService configurationService;

    public ManagementDashboardService(DashboardWriter dashboardWriter, ReportWriter reportWriter, ConfigurationService configurationService) {
        this.dashboardWriter = dashboardWriter;
        this.reportWriter = reportWriter;
        this.configurationService = configurationService;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() {
        if (this.configurationService.getEntityConfiguration().getCreateOnStartup().booleanValue()) {
            LOG.info("Deleting Management entities");
            this.reportWriter.deleteAllManagementReports();
            this.dashboardWriter.deleteManagementDashboard();
            LOG.info("Creating Management Reports and Management Dashboard");
            this.createManagementDashboardForReports(List.of(this.createProcessesCurrentlyInProgressReport(new PositionDto(0, 0), new DimensionDto(4, 2)), this.createProcessesStartedInLastSixMonthsReport(new PositionDto(4, 0), new DimensionDto(14, 4)), this.createProcessesEndedInLastSixMonthsReport(new PositionDto(0, 2), new DimensionDto(4, 2))));
            LOG.info("Finished creating Management entities");
        }
    }

    private DashboardReportTileDto createProcessesCurrentlyInProgressReport(PositionDto positionDto, DimensionDto dimensionDto) {
        ProcessReportDataDto processInstancesCurrentlyInProgressReport = ((ProcessReportDataDto.ProcessReportDataDtoBuilder)ProcessReportDataDto.builder().definitions(Collections.emptyList())).view(new ProcessViewDto(ProcessViewEntity.PROCESS_INSTANCE, ViewProperty.FREQUENCY)).groupBy((ProcessGroupByDto)new NoneGroupByDto()).visualization(ProcessVisualization.NUMBER).filter(ProcessFilterBuilder.filter().runningInstancesOnly().add().buildList()).managementReport(true).build();
        String reportId = this.createReportAndGetId(processInstancesCurrentlyInProgressReport, CURRENTLY_IN_PROGRESS_NAME_LOCALIZATION_CODE, CURRENTLY_IN_PROGRESS_DESCRIPTION_LOCALIZATION_CODE);
        return this.buildDashboardReportTileDto(positionDto, dimensionDto, reportId);
    }

    private DashboardReportTileDto createProcessesStartedInLastSixMonthsReport(PositionDto positionDto, DimensionDto dimensionDto) {
        ProcessReportDataDto processInstancesStartedInLastSixMonthsReport = ((ProcessReportDataDto.ProcessReportDataDtoBuilder)((ProcessReportDataDto.ProcessReportDataDtoBuilder)ProcessReportDataDto.builder().definitions(Collections.emptyList())).view(new ProcessViewDto(ProcessViewEntity.PROCESS_INSTANCE, ViewProperty.FREQUENCY)).groupBy((ProcessGroupByDto)new StartDateGroupByDto(new DateGroupByValueDto(AggregateByDateUnit.MONTH))).distributedBy((ProcessReportDistributedByDto)new ProcessDistributedByDto()).visualization(ProcessVisualization.BAR).filter(ProcessFilterBuilder.filter().rollingInstanceStartDate().start(Long.valueOf(6L), DateUnit.MONTHS).add().buildList()).configuration(SingleReportConfigurationDto.builder().stackedBar(Boolean.valueOf(true)).yLabel("pi").xLabel("endDate").build())).managementReport(true).build();
        String reportId = this.createReportAndGetId(processInstancesStartedInLastSixMonthsReport, STARTED_IN_LAST_SIX_MONTHS_NAME_LOCALIZATION_CODE, STARTED_IN_LAST_SIX_MONTHS_DESCRIPTION_LOCALIZATION_CODE);
        return this.buildDashboardReportTileDto(positionDto, dimensionDto, reportId);
    }

    private DashboardReportTileDto createProcessesEndedInLastSixMonthsReport(PositionDto positionDto, DimensionDto dimensionDto) {
        ProcessReportDataDto processInstancesEndedInLastSixMonthsReport = ((ProcessReportDataDto.ProcessReportDataDtoBuilder)ProcessReportDataDto.builder().definitions(Collections.emptyList())).view(new ProcessViewDto(ProcessViewEntity.PROCESS_INSTANCE, ViewProperty.FREQUENCY)).groupBy((ProcessGroupByDto)new NoneGroupByDto()).visualization(ProcessVisualization.NUMBER).filter(ProcessFilterBuilder.filter().rollingInstanceEndDate().start(Long.valueOf(6L), DateUnit.MONTHS).add().buildList()).managementReport(true).build();
        String reportId = this.createReportAndGetId(processInstancesEndedInLastSixMonthsReport, ENDED_IN_LAST_SIX_MONTHS_NAME_LOCALIZATION_CODE, ENDED_IN_LAST_SIX_MONTHS_DESCRIPTION_LOCALIZATION_CODE);
        return this.buildDashboardReportTileDto(positionDto, dimensionDto, reportId);
    }

    private DashboardReportTileDto buildDashboardReportTileDto(PositionDto positionDto, DimensionDto dimensionDto, String reportId) {
        return DashboardReportTileDto.builder().id(reportId).type(DashboardTileType.OPTIMIZE_REPORT).position(positionDto).dimensions(dimensionDto).build();
    }

    private void createManagementDashboardForReports(List<DashboardReportTileDto> reportsForDashboard) {
        DashboardDefinitionRestDto dashboardDefinition = new DashboardDefinitionRestDto();
        dashboardDefinition.setId(MANAGEMENT_DASHBOARD_ID);
        dashboardDefinition.setName(MANAGEMENT_DASHBOARD_LOCALIZATION_CODE);
        dashboardDefinition.setTiles(reportsForDashboard);
        DashboardInstanceStartDateFilterDto filterDto = new DashboardInstanceStartDateFilterDto();
        RollingDateFilterDataDto rollingFilter = new RollingDateFilterDataDto(new RollingDateFilterStartDto(Long.valueOf(12L), DateUnit.MONTHS));
        filterDto.setData((FilterDataDto)new DashboardDateFilterDataDto((DateFilterDataDto)rollingFilter));
        dashboardDefinition.setAvailableFilters(List.of(filterDto));
        dashboardDefinition.setManagementDashboard(true);
        this.dashboardWriter.saveDashboard(dashboardDefinition);
    }

    private String createReportAndGetId(ProcessReportDataDto processReportDataDto, String localisationCodeForName, String localisationCodeForDescription) {
        return this.reportWriter.createNewSingleProcessReport(null, processReportDataDto, localisationCodeForName, localisationCodeForDescription, null).getId();
    }
}

