/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.collection;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDataDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.collection.PartialCollectionDataDto;
import io.camunda.optimize.dto.optimize.query.collection.PartialCollectionDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionRestDto;
import io.camunda.optimize.dto.optimize.rest.ConflictResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.collection.CollectionEntityService;
import io.camunda.optimize.service.db.reader.CollectionReader;
import io.camunda.optimize.service.db.writer.CollectionWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeCollectionConflictException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.relations.CollectionRelationService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.IdGenerator;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CollectionService {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionService.class);
    private final AuthorizedCollectionService authorizedCollectionService;
    private final CollectionRelationService collectionRelationService;
    private final CollectionEntityService collectionEntityService;
    private final CollectionWriter collectionWriter;
    private final CollectionReader collectionReader;
    private final AbstractIdentityService identityService;

    public CollectionService(AuthorizedCollectionService authorizedCollectionService, CollectionRelationService collectionRelationService, CollectionEntityService collectionEntityService, CollectionWriter collectionWriter, CollectionReader collectionReader, AbstractIdentityService identityService) {
        this.authorizedCollectionService = authorizedCollectionService;
        this.collectionRelationService = collectionRelationService;
        this.collectionEntityService = collectionEntityService;
        this.collectionWriter = collectionWriter;
        this.collectionReader = collectionReader;
        this.identityService = identityService;
    }

    public List<CollectionDefinitionDto> getAllCollections() {
        return this.collectionReader.getAllCollections();
    }

    public IdResponseDto createNewCollectionAndReturnId(String userId, PartialCollectionDefinitionRequestDto partialCollectionDefinitionDto) {
        if (!this.identityService.getEnabledAuthorizations().contains((Object)AuthorizationType.ENTITY_EDITOR)) {
            throw new ForbiddenException("User is not an authorized entity editor");
        }
        return this.collectionWriter.createNewCollectionAndReturnId(userId, partialCollectionDefinitionDto);
    }

    public Optional<IdResponseDto> createNewCollectionWithPresetId(String userId, PartialCollectionDefinitionRequestDto partialCollectionDefinitionDto, String presetId, boolean automaticallyCreated) {
        try {
            return Optional.of(this.collectionWriter.createNewCollectionAndReturnId(userId, partialCollectionDefinitionDto, presetId, automaticallyCreated));
        }
        catch (OptimizeRuntimeException e) {
            if (Optional.ofNullable(this.getCollectionDefinition(presetId)).isEmpty()) {
                LOG.error("Unexpected error when trying to create collection with ID " + presetId, (Throwable)e);
                throw e;
            }
            return Optional.empty();
        }
    }

    public AuthorizedCollectionDefinitionRestDto getCollectionDefinitionRestDto(String userId, String collectionId) {
        LOG.debug("Fetching resolved collection with id [{}]", (Object)collectionId);
        AuthorizedCollectionDefinitionDto collectionDefinition = this.authorizedCollectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId);
        return AuthorizedCollectionDefinitionRestDto.from((AuthorizedCollectionDefinitionDto)collectionDefinition);
    }

    public void updatePartialCollection(String userId, String collectionId, PartialCollectionDefinitionRequestDto collectionUpdate) {
        this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        CollectionDefinitionUpdateDto updateDto = new CollectionDefinitionUpdateDto();
        updateDto.setName(collectionUpdate.getName());
        if (collectionUpdate.getData() != null) {
            PartialCollectionDataDto collectionDataDto = new PartialCollectionDataDto();
            collectionDataDto.setConfiguration(collectionUpdate.getData().getConfiguration());
            updateDto.setData(collectionDataDto);
        }
        updateDto.setLastModifier(userId);
        updateDto.setLastModified(LocalDateUtil.getCurrentDateTime());
        this.collectionWriter.updateCollection(updateDto, collectionId);
    }

    public void deleteCollection(String userId, String collectionId, boolean force) {
        Set<ConflictedItemDto> conflictedItems;
        AuthorizedCollectionDefinitionDto collectionDefinition = this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        if (!force && !(conflictedItems = this.getConflictedItemsForDelete(userId, collectionId)).isEmpty()) {
            throw new OptimizeCollectionConflictException(conflictedItems);
        }
        this.collectionRelationService.handleDeleted(collectionDefinition.getDefinitionDto());
        this.collectionWriter.deleteCollection(collectionId);
    }

    public ConflictResponseDto getDeleteConflictingItems(String userId, String collectionId) {
        return new ConflictResponseDto(this.getConflictedItemsForDelete(userId, collectionId));
    }

    public CollectionDefinitionDto getCollectionDefinition(String collectionId) {
        return this.collectionReader.getCollection(collectionId).orElseThrow(() -> new NotFoundException("Collection with ID [" + collectionId + "] does not exist."));
    }

    private AuthorizedCollectionDefinitionDto getCollectionDefinition(String userId, String collectionId) {
        return this.authorizedCollectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId);
    }

    public List<AuthorizedCollectionDefinitionDto> getAllCollectionDefinitions(String userId) {
        return this.authorizedCollectionService.getAuthorizedCollectionDefinitions(userId);
    }

    public IdResponseDto copyCollection(String userId, String collectionId, String newCollectionName) {
        AuthorizedCollectionDefinitionDto oldCollection = this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        CollectionDefinitionDto newCollection = new CollectionDefinitionDto((CollectionDataDto)oldCollection.getDefinitionDto().getData(), OffsetDateTime.now(), IdGenerator.getNextId(), (String)(newCollectionName != null ? newCollectionName : oldCollection.getDefinitionDto().getName() + " \u2013 Copy"), OffsetDateTime.now(), userId, userId);
        CollectionDefinitionRestDto oldResolvedCollection = this.getCollectionDefinitionRestDto(oldCollection).getDefinitionDto();
        this.collectionWriter.createNewCollection(newCollection);
        this.collectionEntityService.copyCollectionEntities(userId, oldResolvedCollection, newCollection.getId());
        return new IdResponseDto(newCollection.getId());
    }

    private Set<ConflictedItemDto> getConflictedItemsForDelete(String userId, String collectionId) {
        return this.collectionRelationService.getConflictedItemsForDelete(this.getCollectionDefinition(userId, collectionId).getDefinitionDto());
    }

    private AuthorizedCollectionDefinitionRestDto getCollectionDefinitionRestDto(AuthorizedCollectionDefinitionDto collectionDefinitionDto) {
        return AuthorizedCollectionDefinitionRestDto.from((AuthorizedCollectionDefinitionDto)collectionDefinitionDto);
    }
}

