/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.collection;

import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ReportType;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDataDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionEntity;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryUpdateDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionResponseDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemType;
import io.camunda.optimize.dto.optimize.rest.DefinitionVersionResponseDto;
import io.camunda.optimize.dto.optimize.rest.collection.CollectionScopeEntryResponseDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.db.writer.CollectionWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.exceptions.conflict.OptimizeCollectionConflictException;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import io.camunda.optimize.service.tenant.TenantService;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CollectionScopeService {
    public static final String SCOPE_NOT_AUTHORIZED_MESSAGE = "User [%s] is not authorized to add scope [%s]. Either they aren't allowed to access the definition or the provided tenants.";
    private static final String UNAUTHORIZED_TENANT_MASK_NAME = "Unauthorized Tenant";
    private static final String UNAUTHORIZED_TENANT_MASK_ID = "__unauthorizedTenantId__";
    public static final TenantDto UNAUTHORIZED_TENANT_MASK = new TenantDto("__unauthorizedTenantId__", "Unauthorized Tenant", "unknownEngine");
    private static final Logger LOG = LoggerFactory.getLogger(CollectionScopeService.class);
    private final TenantService tenantService;
    private final DefinitionService definitionService;
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final ReportReader reportReader;
    private final AuthorizedCollectionService authorizedCollectionService;
    private final CollectionWriter collectionWriter;
    private final ReportService reportService;

    public CollectionScopeService(TenantService tenantService, DefinitionService definitionService, DataSourceDefinitionAuthorizationService definitionAuthorizationService, ReportReader reportReader, AuthorizedCollectionService authorizedCollectionService, CollectionWriter collectionWriter, ReportService reportService) {
        this.tenantService = tenantService;
        this.definitionService = definitionService;
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.reportReader = reportReader;
        this.authorizedCollectionService = authorizedCollectionService;
        this.collectionWriter = collectionWriter;
        this.reportService = reportService;
    }

    public List<CollectionScopeEntryResponseDto> getCollectionScope(String userId, String collectionId) {
        return ((CollectionDataDto)this.authorizedCollectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId).getDefinitionDto().getData()).getScope().stream().map(scope -> {
            List<TenantDto> authorizedTenantDtos = this.resolveAuthorizedTenantsForScopeEntry(userId, (CollectionScopeEntryDto)scope);
            List unauthorizedTenantsIds = scope.getTenants();
            authorizedTenantDtos.stream().map(TenantDto::getId).forEach(unauthorizedTenantsIds::remove);
            authorizedTenantDtos.addAll(unauthorizedTenantsIds.stream().map(t -> UNAUTHORIZED_TENANT_MASK).toList());
            return CollectionScopeEntryResponseDto.from(scope, authorizedTenantDtos);
        }).filter(collectionScopeEntryRestDto -> collectionScopeEntryRestDto.getTenants().stream().anyMatch(t -> !UNAUTHORIZED_TENANT_MASK_ID.equals(t.getId()))).peek(collectionScopeEntryRestDto -> collectionScopeEntryRestDto.setDefinitionName(this.getDefinitionName(userId, (CollectionScopeEntryResponseDto)collectionScopeEntryRestDto))).sorted(Comparator.comparing(CollectionScopeEntryResponseDto::getDefinitionType).thenComparing(CollectionScopeEntryResponseDto::getDefinitionName)).collect(Collectors.toList());
    }

    public List<DefinitionResponseDto> getCollectionDefinitions(DefinitionType definitionType, String userId, String collectionId) {
        Map<String, List<String>> keysAndTenants = this.getAvailableKeysAndTenantsFromCollectionScope(userId, definitionType, collectionId);
        if (keysAndTenants.isEmpty()) {
            return Collections.emptyList();
        }
        return this.definitionService.getFullyImportedDefinitions(definitionType, keysAndTenants.keySet(), keysAndTenants.values().stream().flatMap(Collection::stream).collect(Collectors.toList()), userId);
    }

    public List<DefinitionVersionResponseDto> getCollectionDefinitionVersionsByKeyAndType(DefinitionType type, String key, String userId, String collectionId) {
        Optional<CollectionScopeEntryDto> optionalScopeEntry = this.getCollectionScopeEntryDtoStream(userId, collectionId).filter(entry -> entry.getDefinitionType().equals((Object)type) && entry.getDefinitionKey().equals(key)).findFirst();
        if (optionalScopeEntry.isEmpty()) {
            return Collections.emptyList();
        }
        return this.definitionService.getDefinitionVersions(type, key, userId, optionalScopeEntry.get().getTenants());
    }

    public List<TenantDto> getCollectionDefinitionTenantsByKeyAndType(DefinitionType type, String key, String userId, List<String> versions, String collectionId) {
        Optional<CollectionScopeEntryDto> optionalScopeEntry = this.getCollectionScopeEntryDtoStream(userId, collectionId).filter(entry -> entry.getDefinitionType().equals((Object)type) && entry.getDefinitionKey().equals(key)).findFirst();
        if (optionalScopeEntry.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet scopeTenantIds = Sets.newHashSet((Iterable)optionalScopeEntry.get().getTenants());
        Supplier<String> latestVersionAvailableInScopeSupplier = () -> this.definitionService.getDefinitionVersions(type, key, userId, ((CollectionScopeEntryDto)optionalScopeEntry.get()).getTenants()).stream().findFirst().map(DefinitionVersionResponseDto::getVersion).orElseThrow(() -> new OptimizeValidationException("Could not resolve latest version."));
        return this.definitionService.getDefinitionTenants(type, key, userId, versions, latestVersionAvailableInScopeSupplier).stream().filter(tenantDto -> scopeTenantIds.contains(tenantDto.getId())).collect(Collectors.toList());
    }

    public void addScopeEntriesToCollection(String userId, String collectionId, List<CollectionScopeEntryDto> scopeUpdates) {
        this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        this.verifyUserIsAuthorizedToAccessScopesOrFail(userId, scopeUpdates);
        this.collectionWriter.addScopeEntriesToCollection(userId, collectionId, scopeUpdates);
    }

    public void addScopeEntriesToCollectionAsAService(String collectionId, List<CollectionScopeEntryDto> scopeUpdates) {
        this.collectionWriter.addScopeEntriesToCollection("System User", collectionId, scopeUpdates);
    }

    private void verifyUserIsAuthorizedToAccessScopesOrFail(String userId, List<CollectionScopeEntryDto> scopeEntries) {
        scopeEntries.forEach(scopeEntry -> {
            boolean isAuthorized = this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, scopeEntry.getDefinitionType(), scopeEntry.getDefinitionKey(), scopeEntry.getTenants());
            if (!isAuthorized) {
                String message = String.format(SCOPE_NOT_AUTHORIZED_MESSAGE, userId, scopeEntry.getId());
                throw new ForbiddenException(message);
            }
        });
    }

    public void deleteScopeEntry(String userId, String collectionId, String scopeEntryId, boolean force) {
        this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        List<SingleReportDefinitionDto<?>> reportsAffectedByScopeDeletion = this.getAllReportsAffectedByScopeDeletion(collectionId, scopeEntryId);
        if (!force) {
            this.checkForConflictsOnScopeDeletion(userId, reportsAffectedByScopeDeletion);
        }
        this.deleteReports(userId, reportsAffectedByScopeDeletion);
        this.collectionWriter.removeScopeEntry(collectionId, scopeEntryId, userId);
    }

    private void deleteReports(String userId, List<SingleReportDefinitionDto<?>> reportsAffectedByScopeUpdate) {
        reportsAffectedByScopeUpdate.stream().map(ReportDefinitionDto::getId).forEach(reportId -> this.reportService.deleteReportAsUser(userId, (String)reportId, true));
    }

    public Set<ConflictedItemDto> getAllConflictsOnScopeDeletion(String userId, String collectionId, String scopeId) {
        List<SingleReportDefinitionDto<?>> reportsAffectedByScopeDeletion = this.getAllReportsAffectedByScopeDeletion(collectionId, scopeId);
        return this.getConflictsForReports(userId, reportsAffectedByScopeDeletion);
    }

    private void checkForConflictsOnScopeDeletion(String userId, List<SingleReportDefinitionDto<?>> reportsAffectedByScopeDeletion) {
        Set<ConflictedItemDto> conflictedItems = this.getConflictsForReports(userId, reportsAffectedByScopeDeletion);
        if (!conflictedItems.isEmpty()) {
            throw new OptimizeCollectionConflictException(conflictedItems);
        }
    }

    private Set<ConflictedItemDto> getConflictsForReports(String userId, List<SingleReportDefinitionDto<?>> reports) {
        return reports.stream().flatMap(report -> {
            Set<ConflictedItemDto> reportConflicts = this.reportService.getReportDeleteConflictingItems(userId, report.getId()).getConflictedItems();
            reportConflicts.add(this.reportToConflictedItem((CollectionEntity)report));
            return reportConflicts.stream();
        }).collect(Collectors.toSet());
    }

    private List<SingleReportDefinitionDto<?>> getAllReportsAffectedByScopeDeletion(String collectionId, String scopeEntryId) {
        CollectionScopeEntryDto scopeEntry = new CollectionScopeEntryDto(scopeEntryId);
        List<ReportDefinitionDto> reportsInCollection = this.reportReader.getReportsForCollectionOmitXml(collectionId);
        return reportsInCollection.stream().filter(report -> !report.isCombined()).map(report -> (SingleReportDefinitionDto)report).filter(report -> this.reportInSameScopeAsGivenScope(scopeEntry, (SingleReportDefinitionDto<?>)report)).collect(Collectors.toList());
    }

    private boolean reportInSameScopeAsGivenScope(CollectionScopeEntryDto scopeEntry, SingleReportDefinitionDto<?> report) {
        return ((SingleReportDataDto)report.getData()).getDefinitions().stream().map(definition -> new CollectionScopeEntryDto(report.getDefinitionType(), definition.getKey())).anyMatch(entry -> entry.equals((Object)scopeEntry));
    }

    public void updateScopeEntry(String userId, String collectionId, CollectionScopeEntryUpdateDto scopeUpdate, String scopeEntryId, boolean force) {
        CollectionDefinitionDto collectionDefinition = this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId).getDefinitionDto();
        CollectionScopeEntryDto currentScope = this.getScopeOfCollection(scopeEntryId, collectionDefinition);
        this.replaceMaskedTenantsInUpdateWithRealOnes(userId, scopeUpdate, currentScope);
        Set<String> tenantsThatWillBeRemoved = this.retrieveRemovedTenants(scopeUpdate, currentScope);
        this.updateScopeInCollection(scopeEntryId, scopeUpdate, collectionDefinition);
        List<SingleReportDefinitionDto<?>> reportsAffectedByScopeUpdate = this.getReportsAffectedByScopeUpdate(collectionId, collectionDefinition);
        if (!force) {
            this.checkForConflictOnUpdate(reportsAffectedByScopeUpdate);
        }
        this.updateReportsWithNewTenants(userId, tenantsThatWillBeRemoved, reportsAffectedByScopeUpdate);
        this.collectionWriter.updateScopeEntity(collectionId, scopeUpdate, userId, scopeEntryId);
    }

    private Set<String> retrieveRemovedTenants(CollectionScopeEntryUpdateDto scopeUpdate, CollectionScopeEntryDto currentScope) {
        HashSet<String> tenantsToBeRemoved = new HashSet<String>(currentScope.getTenants());
        scopeUpdate.getTenants().forEach(tenantsToBeRemoved::remove);
        return tenantsToBeRemoved;
    }

    private void updateReportsWithNewTenants(String userId, Set<String> tenantsToBeRemoved, List<SingleReportDefinitionDto<?>> reportsAffectedByScopeUpdate) {
        Map<ReportType, List<SingleReportDefinitionDto>> byDefinitionType = reportsAffectedByScopeUpdate.stream().peek(r -> ((SingleReportDataDto)r.getData()).getTenantIds().removeAll(tenantsToBeRemoved)).collect(Collectors.groupingBy(ReportDefinitionDto::getReportType));
        ((List)byDefinitionType.getOrDefault(ReportType.DECISION, new ArrayList())).stream().filter(r -> r instanceof SingleDecisionReportDefinitionRequestDto).map(r -> (SingleDecisionReportDefinitionRequestDto)r).forEach(r -> this.reportService.updateSingleDecisionReport(r.getId(), (SingleDecisionReportDefinitionRequestDto)r, userId, true));
        ((List)byDefinitionType.getOrDefault(ReportType.PROCESS, new ArrayList())).stream().filter(r -> r instanceof SingleProcessReportDefinitionRequestDto).map(r -> (SingleProcessReportDefinitionRequestDto)r).forEach(r -> this.reportService.updateSingleProcessReport(r.getId(), (SingleProcessReportDefinitionRequestDto)r, userId, true));
    }

    private CollectionScopeEntryDto getScopeOfCollection(String scopeEntryId, CollectionDefinitionDto collectionDefinition) {
        return ((CollectionDataDto)collectionDefinition.getData()).getScope().stream().filter(scope -> scope.getId().equals(scopeEntryId)).findFirst().orElseThrow(() -> new NotFoundException(String.format("Unknown scope entry for collection [%s] and scope [%s]", collectionDefinition.getId(), scopeEntryId)));
    }

    private void checkForConflictOnUpdate(List<SingleReportDefinitionDto<?>> reportsAffectedByUpdate) {
        Set<ConflictedItemDto> conflictedItems = reportsAffectedByUpdate.stream().map(this::reportToConflictedItem).collect(Collectors.toSet());
        if (!conflictedItems.isEmpty()) {
            throw new OptimizeCollectionConflictException(conflictedItems);
        }
    }

    public boolean hasConflictsForCollectionScopeDelete(String userId, String collectionId, List<String> collectionScopeIds) {
        this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        return collectionScopeIds.stream().anyMatch(scopeEntryId -> !this.getAllConflictsOnScopeDeletion(userId, collectionId, (String)scopeEntryId).isEmpty());
    }

    public void bulkDeleteCollectionScopes(String userId, String collectionId, List<String> collectionScopeIds) {
        ArrayList<String> collectionScopesToDelete = new ArrayList<String>();
        this.authorizedCollectionService.getAuthorizedCollectionAndVerifyUserAuthorizedToManageOrFail(userId, collectionId);
        for (String collectionScopeId : collectionScopeIds) {
            List<SingleReportDefinitionDto<?>> reportsAffectedByScopeDeletion = this.getAllReportsAffectedByScopeDeletion(collectionId, collectionScopeId);
            try {
                this.deleteReports(userId, reportsAffectedByScopeDeletion);
                collectionScopesToDelete.add(collectionScopeId);
            }
            catch (OptimizeRuntimeException e) {
                LOG.debug("There was an error while deleting reports associated to collection scope with id {}. The scope cannot be deleted.", (Object)collectionScopeId);
            }
        }
        this.collectionWriter.removeScopeEntries(collectionId, collectionScopesToDelete, userId);
    }

    private List<SingleReportDefinitionDto<?>> getReportsAffectedByScopeUpdate(String collectionId, CollectionDefinitionDto collectionDefinition) {
        List<ReportDefinitionDto> reportsInCollection = this.reportReader.getReportsForCollectionIncludingXml(collectionId);
        return reportsInCollection.stream().filter(report -> !report.isCombined()).map(report -> (SingleReportDefinitionDto)report).filter(report -> !this.reportService.isReportAllowedForCollectionScope((SingleReportDefinitionDto<?>)report, collectionDefinition)).collect(Collectors.toList());
    }

    private void updateScopeInCollection(String scopeEntryId, CollectionScopeEntryUpdateDto scopeUpdate, CollectionDefinitionDto collectionDefinition) {
        this.getScopeOfCollection(scopeEntryId, collectionDefinition).setTenants(scopeUpdate.getTenants());
    }

    private void replaceMaskedTenantsInUpdateWithRealOnes(String userId, CollectionScopeEntryUpdateDto scopeUpdate, CollectionScopeEntryDto currentScope) {
        List<String> unauthorizedTenantsOfCurrentScope = currentScope.getTenants().stream().filter(tenantId -> !this.tenantService.isAuthorizedToSeeTenant(userId, (String)tenantId)).toList();
        List<String> allTenantsWithMaskedTenantsBeingResolved = Stream.concat(scopeUpdate.getTenants().stream().filter(tenantId -> !UNAUTHORIZED_TENANT_MASK_ID.equals(tenantId)), unauthorizedTenantsOfCurrentScope.stream()).distinct().toList();
        scopeUpdate.setTenants(allTenantsWithMaskedTenantsBeingResolved);
    }

    public Map<String, List<String>> getAvailableKeysAndTenantsFromCollectionScope(String userId, DefinitionType definitionType, String collectionId) {
        if (collectionId == null) {
            return Collections.emptyMap();
        }
        return this.getCollectionScopeEntryDtoStream(userId, collectionId).filter(scopeEntryDto -> definitionType.equals((Object)scopeEntryDto.getDefinitionType())).map(scopeEntryDto -> new AbstractMap.SimpleEntry<String, List>(scopeEntryDto.getDefinitionKey(), scopeEntryDto.getTenants())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Stream<CollectionScopeEntryDto> getCollectionScopeEntryDtoStream(String userId, String collectionId) {
        return ((CollectionDataDto)this.authorizedCollectionService.getAuthorizedCollectionDefinitionOrFail(userId, collectionId).getDefinitionDto().getData()).getScope().stream().peek(scope -> scope.setTenants(this.resolveAuthorizedTenantsForScopeEntry(userId, (CollectionScopeEntryDto)scope).stream().map(TenantDto::getId).collect(Collectors.toList()))).filter(scopeEntryDto -> !scopeEntryDto.getTenants().isEmpty());
    }

    private List<TenantDto> resolveAuthorizedTenantsForScopeEntry(String userId, CollectionScopeEntryDto scope) {
        try {
            return this.definitionService.getDefinitionWithAvailableTenants(scope.getDefinitionType(), scope.getDefinitionKey(), userId).map(DefinitionResponseDto::getTenants).orElseGet(ArrayList::new).stream().filter(tenantDto -> scope.getTenants().contains(tenantDto.getId())).collect(Collectors.toList());
        }
        catch (ForbiddenException e) {
            return new ArrayList<TenantDto>();
        }
    }

    private String getDefinitionName(String userId, CollectionScopeEntryResponseDto scope) {
        return this.definitionService.getDefinitionWithAvailableTenants(scope.getDefinitionType(), scope.getDefinitionKey(), userId).map(SimpleDefinitionDto::getName).orElse(scope.getDefinitionKey());
    }

    private ConflictedItemDto reportToConflictedItem(CollectionEntity collectionEntity) {
        return new ConflictedItemDto(collectionEntity.getId(), ConflictedItemType.REPORT, collectionEntity.getName());
    }
}

