/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import io.camunda.optimize.service.cleanup.CleanupService;
import io.camunda.optimize.service.db.writer.variable.ExternalProcessVariableWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupConfiguration;
import java.time.OffsetDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExternalVariableCleanupService
extends CleanupService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalVariableCleanupService.class);
    private final ConfigurationService configurationService;
    private final ExternalProcessVariableWriter externalProcessVariableWriter;

    public ExternalVariableCleanupService(ConfigurationService configurationService, ExternalProcessVariableWriter externalProcessVariableWriter) {
        this.configurationService = configurationService;
        this.externalProcessVariableWriter = externalProcessVariableWriter;
    }

    @Override
    public boolean isEnabled() {
        return this.getCleanupConfiguration().getExternalVariableCleanupConfiguration().isEnabled();
    }

    @Override
    public void doCleanup(OffsetDateTime startTime) {
        OffsetDateTime endDate = startTime.minus(this.getCleanupConfiguration().getTtl());
        LOG.info("Performing cleanup on external variables with a timestamp older than {}", (Object)endDate);
        this.externalProcessVariableWriter.deleteExternalVariablesIngestedBefore(endDate);
        LOG.info("Finished cleanup on external variables with a timestamp older than {}", (Object)endDate);
    }

    private CleanupConfiguration getCleanupConfiguration() {
        return this.configurationService.getCleanupServiceConfiguration();
    }
}

