/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.alert;

import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.dto.optimize.query.alert.AlertInterval;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;

public abstract class AbstractAlertFactory<T extends Job> {
    private final ApplicationContext applicationContext;

    protected AbstractAlertFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private long durationInMs(AlertInterval checkInterval) {
        return Duration.between(OffsetDateTime.now(), OffsetDateTime.now().plus(checkInterval.getValue(), this.unitOf(checkInterval.getUnit().name()))).toMillis();
    }

    private ChronoUnit unitOf(String unit) {
        return ChronoUnit.valueOf(unit.toUpperCase());
    }

    public Trigger createTrigger(AlertDefinitionDto alert, JobDetail jobDetail) {
        SimpleTrigger trigger = null;
        if (this.getInterval(alert) != null) {
            OffsetDateTime startFuture = OffsetDateTime.now().plus(this.getInterval(alert).getValue(), this.unitOf(this.getInterval(alert).getUnit().name()));
            trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(alert), this.getTriggerGroup()).startAt(new Date(startFuture.toInstant().toEpochMilli())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.durationInMs(this.getInterval(alert))).repeatForever()).forJob(jobDetail).build();
        }
        return trigger;
    }

    public JobDetail createJobDetails(AlertDefinitionDto alert) {
        JobDetailFactoryBean jobDetailFactoryBean = new JobDetailFactoryBean();
        jobDetailFactoryBean.setJobClass(this.getJobClass());
        jobDetailFactoryBean.setDurability(true);
        jobDetailFactoryBean.setName(this.getJobName(alert));
        jobDetailFactoryBean.setGroup(this.getJobGroup());
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("alertId", alert.getId());
        jobDetailFactoryBean.setJobDataAsMap(dataMap);
        jobDetailFactoryBean.setApplicationContext(this.getApplicationContext());
        jobDetailFactoryBean.afterPropertiesSet();
        return jobDetailFactoryBean.getObject();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected JobKey getJobKey(AlertDefinitionDto alert) {
        return new JobKey(this.getJobName(alert), this.getJobGroup());
    }

    protected TriggerKey getTriggerKey(AlertDefinitionDto toDelete) {
        return new TriggerKey(this.getTriggerName(toDelete), this.getTriggerGroup());
    }

    protected abstract AlertInterval getInterval(AlertDefinitionDto var1);

    protected abstract Class<T> getJobClass();

    protected abstract String getJobGroup();

    protected abstract String getJobName(AlertDefinitionDto var1);

    protected abstract String getTriggerName(AlertDefinitionDto var1);

    protected abstract String getTriggerGroup();
}

