/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.query.processoverview.KpiResultDto;
import io.camunda.optimize.dto.optimize.query.processoverview.KpiType;
import io.camunda.optimize.dto.optimize.query.processoverview.ProcessOverviewDto;
import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.target_value.SingleReportTargetValueDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.target_value.TargetDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.target_value.TargetValueUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CanceledInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.CompletedOrCanceledFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.DeletedIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutedFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ExecutingFlowNodeFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeDurationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FlowNodeStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.MultipleVariableFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NoIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NonCanceledInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.NonSuspendedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.OpenIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.ResolvedIncidentFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningFlowNodesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.RunningInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.SuspendedInstancesOnlyFilterDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.VariableFilterDto;
import io.camunda.optimize.rest.mapper.ReportRestMapper;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.db.report.PlainReportEvaluationHandler;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.util.ValidationHelper;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class KpiService {
    private static final Logger LOG = LoggerFactory.getLogger(KpiService.class);
    private final ReportService reportService;
    private final LocalizationService localizationService;
    private final PlainReportEvaluationHandler reportEvaluationHandler;

    public KpiService(ReportService reportService, LocalizationService localizationService, PlainReportEvaluationHandler reportEvaluationHandler) {
        this.reportService = reportService;
        this.localizationService = localizationService;
        this.reportEvaluationHandler = reportEvaluationHandler;
    }

    public List<KpiResultDto> evaluateKpiReports(String processDefinitionKey) {
        List<SingleProcessReportDefinitionRequestDto> kpiReports = this.getValidKpiReportsForProcessDefinition(processDefinitionKey);
        ArrayList<KpiResultDto> kpiResponseDtos = new ArrayList<KpiResultDto>();
        for (SingleProcessReportDefinitionRequestDto report : kpiReports) {
            SingleReportEvaluationResult evaluationResult = (SingleReportEvaluationResult)this.reportEvaluationHandler.evaluateReport(ReportEvaluationInfo.builder(report).timezone(ZoneId.systemDefault()).build()).getEvaluationResult();
            if (!(evaluationResult.getFirstCommandResult().getFirstMeasureData() instanceof Double) && evaluationResult.getFirstCommandResult().getFirstMeasureData() != null) continue;
            Double evaluationValue = (Double)evaluationResult.getFirstCommandResult().getFirstMeasureData();
            KpiResultDto kpiResponseDto = new KpiResultDto();
            kpiResponseDto.setReportId(report.getId());
            kpiResponseDto.setCollectionId(report.getCollectionId());
            if (evaluationValue != null) {
                kpiResponseDto.setValue(evaluationValue.toString());
            }
            kpiResponseDtos.add(kpiResponseDto);
        }
        return kpiResponseDtos;
    }

    public List<KpiResultDto> extractMostRecentKpiResultsForCurrentKpiReportsForProcess(ProcessOverviewDto processOverviewDto, String locale) {
        ArrayList<KpiResultDto> kpiResponseDtos = new ArrayList<KpiResultDto>();
        List<SingleProcessReportDefinitionRequestDto> currentKpiReports = this.getValidKpiReportsForProcessDefinition(processOverviewDto.getProcessDefinitionKey());
        Map lastKpiEvaluationResults = Optional.ofNullable(processOverviewDto.getLastKpiEvaluationResults()).orElse(Collections.emptyMap());
        for (SingleProcessReportDefinitionRequestDto report : currentKpiReports) {
            if (!lastKpiEvaluationResults.containsKey(report.getId())) continue;
            ReportRestMapper.localizeReportData(report, locale, this.localizationService);
            KpiResultDto kpiResponseDto = new KpiResultDto();
            kpiResponseDto.setValue((String)lastKpiEvaluationResults.get(report.getId()));
            this.getTargetAndUnit(report).ifPresent(targetAndUnit -> {
                kpiResponseDto.setTarget(targetAndUnit.getTarget());
                kpiResponseDto.setUnit(targetAndUnit.getTargetValueUnit());
            });
            kpiResponseDto.setReportId(report.getId());
            kpiResponseDto.setCollectionId(report.getCollectionId());
            kpiResponseDto.setReportName(report.getName());
            kpiResponseDto.setBelow(this.getIsBelow(report));
            kpiResponseDto.setType(this.getKpiType(report));
            kpiResponseDto.setMeasure((ViewProperty)this.getViewProperty(report).orElse(null));
            kpiResponseDtos.add(kpiResponseDto);
        }
        return kpiResponseDtos;
    }

    private KpiType getKpiType(SingleProcessReportDefinitionRequestDto singleProcessReportDefinitionRequestDto) {
        return this.getViewProperty(singleProcessReportDefinitionRequestDto).filter(measure -> ViewProperty.DURATION.equals(measure) || ViewProperty.PERCENTAGE.equals(measure) && !this.containsQualityFilter(singleProcessReportDefinitionRequestDto)).map(measure -> KpiType.TIME).orElse(KpiType.QUALITY);
    }

    private boolean containsQualityFilter(SingleProcessReportDefinitionRequestDto singleProcessReportDefinitionRequestDto) {
        return ((ProcessReportDataDto)singleProcessReportDefinitionRequestDto.getData()).getFilter().stream().anyMatch(processFilter -> processFilter instanceof FlowNodeStartDateFilterDto || processFilter instanceof FlowNodeEndDateFilterDto || processFilter instanceof VariableFilterDto || processFilter instanceof MultipleVariableFilterDto || processFilter instanceof ExecutedFlowNodeFilterDto || processFilter instanceof ExecutingFlowNodeFilterDto || processFilter instanceof CanceledFlowNodeFilterDto || processFilter instanceof RunningInstancesOnlyFilterDto || processFilter instanceof CompletedInstancesOnlyFilterDto || processFilter instanceof CanceledInstancesOnlyFilterDto || processFilter instanceof NonCanceledInstancesOnlyFilterDto || processFilter instanceof SuspendedInstancesOnlyFilterDto || processFilter instanceof NonSuspendedInstancesOnlyFilterDto || processFilter instanceof FlowNodeDurationFilterDto || processFilter instanceof OpenIncidentFilterDto || processFilter instanceof DeletedIncidentFilterDto || processFilter instanceof ResolvedIncidentFilterDto || processFilter instanceof NoIncidentFilterDto || processFilter instanceof RunningFlowNodesOnlyFilterDto || processFilter instanceof CompletedFlowNodesOnlyFilterDto || processFilter instanceof CanceledFlowNodesOnlyFilterDto || processFilter instanceof CompletedOrCanceledFlowNodesOnlyFilterDto);
    }

    private boolean getIsBelow(SingleProcessReportDefinitionRequestDto singleProcessReportDefinitionRequestDto) {
        SingleReportTargetValueDto targetValue = ((ProcessReportDataDto)singleProcessReportDefinitionRequestDto.getData()).getConfiguration().getTargetValue();
        if (targetValue == null) {
            return false;
        }
        return this.getViewProperty(singleProcessReportDefinitionRequestDto).map(measure -> {
            if (measure.equals((Object)ViewProperty.DURATION)) {
                return targetValue.getDurationProgress().getTarget().getIsBelow();
            }
            return targetValue.getCountProgress().getIsBelow();
        }).orElse(false);
    }

    private Optional<ViewProperty> getViewProperty(SingleProcessReportDefinitionRequestDto singleProcessReportDefinitionRequestDto) {
        List viewProperties = ((ProcessReportDataDto)singleProcessReportDefinitionRequestDto.getData()).getViewProperties();
        if (viewProperties.contains(ViewProperty.DURATION)) {
            return Optional.of(ViewProperty.DURATION);
        }
        if (viewProperties.contains(ViewProperty.FREQUENCY)) {
            return Optional.of(ViewProperty.FREQUENCY);
        }
        if (viewProperties.contains(ViewProperty.PERCENTAGE)) {
            return Optional.of(ViewProperty.PERCENTAGE);
        }
        return Optional.empty();
    }

    private Optional<TargetAndUnit> getTargetAndUnit(SingleProcessReportDefinitionRequestDto singleProcessReportDefinitionRequestDto) {
        SingleReportTargetValueDto targetValue = ((ProcessReportDataDto)singleProcessReportDefinitionRequestDto.getData()).getConfiguration().getTargetValue();
        return this.getViewProperty(singleProcessReportDefinitionRequestDto).map(measure -> {
            if (measure.equals((Object)ViewProperty.DURATION)) {
                TargetDto targetDto = targetValue.getDurationProgress().getTarget();
                return Optional.of(new TargetAndUnit(targetDto.getValue(), targetDto.getUnit()));
            }
            return Optional.of(new TargetAndUnit(targetValue.getCountProgress().getTarget(), null));
        }).orElse(Optional.empty());
    }

    public List<SingleProcessReportDefinitionRequestDto> getValidKpiReportsForProcessDefinition(String processDefinitionKey) {
        List<SingleProcessReportDefinitionRequestDto> validKpis = this.reportService.getAllReportsForProcessDefinitionKeyOmitXml(processDefinitionKey).stream().filter(SingleProcessReportDefinitionRequestDto.class::isInstance).map(SingleProcessReportDefinitionRequestDto.class::cast).filter(processReport -> ((ProcessReportDataDto)processReport.getData()).getConfiguration().getTargetValue() != null && ((ProcessReportDataDto)processReport.getData()).getConfiguration().getTargetValue().getIsKpi() == Boolean.TRUE).filter(processReport -> ((ProcessReportDataDto)processReport.getData()).getDefinitions().size() == 1).collect(Collectors.toList());
        validKpis.removeIf(processReport -> !ValidationHelper.isValid(processReport.getData()));
        return validKpis;
    }

    private static class TargetAndUnit {
        private String target;
        private TargetValueUnit targetValueUnit;

        public TargetAndUnit(String target, TargetValueUnit targetValueUnit) {
            this.target = target;
            this.targetValueUnit = targetValueUnit;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public TargetValueUnit getTargetValueUnit() {
            return this.targetValueUnit;
        }

        public void setTargetValueUnit(TargetValueUnit targetValueUnit) {
            this.targetValueUnit = targetValueUnit;
        }

        protected boolean canEqual(Object other) {
            return other instanceof TargetAndUnit;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "KpiService.TargetAndUnit(target=" + this.getTarget() + ", targetValueUnit=" + String.valueOf(this.getTargetValueUnit()) + ")";
        }
    }
}

