/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionResponseDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionWithTenantIdsDto;
import io.camunda.optimize.dto.optimize.query.definition.TenantIdWithDefinitionsDto;
import io.camunda.optimize.dto.optimize.query.definition.TenantWithDefinitionsResponseDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionVersionResponseDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.db.reader.DefinitionReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import io.camunda.optimize.service.tenant.TenantService;
import io.camunda.optimize.service.util.BpmnModelUtil;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import io.camunda.optimize.service.util.configuration.CacheConfiguration;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DefinitionService
implements ConfigurationReloadable {
    public static final TenantDto TENANT_NOT_DEFINED = new TenantDto(null, "Not defined", null);
    private static final Logger LOG = LoggerFactory.getLogger(DefinitionService.class);
    private final DefinitionReader definitionReader;
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final TenantService tenantService;
    private final LoadingCache<String, Map<String, DefinitionOptimizeResponseDto>> latestProcessDefinitionCache;
    private final LoadingCache<String, Map<String, DefinitionOptimizeResponseDto>> latestDecisionDefinitionCache;

    public DefinitionService(DefinitionReader definitionReader, DataSourceDefinitionAuthorizationService definitionAuthorizationService, TenantService tenantService, ConfigurationService configurationService) {
        this.definitionReader = definitionReader;
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.tenantService = tenantService;
        CacheConfiguration definitionCacheConfiguration = configurationService.getCaches().getDefinitions();
        this.latestProcessDefinitionCache = Caffeine.newBuilder().maximumSize((long)definitionCacheConfiguration.getMaxSize()).expireAfterWrite((long)definitionCacheConfiguration.getDefaultTtlMillis(), TimeUnit.MILLISECONDS).build(this::fetchLatestProcessDefinition);
        this.latestDecisionDefinitionCache = Caffeine.newBuilder().maximumSize((long)definitionCacheConfiguration.getMaxSize()).expireAfterWrite((long)definitionCacheConfiguration.getDefaultTtlMillis(), TimeUnit.MILLISECONDS).build(this::fetchLatestDecisionDefinition);
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.latestProcessDefinitionCache.invalidateAll();
        this.latestDecisionDefinitionCache.invalidateAll();
    }

    public String getLatestVersionToKey(DefinitionType type, String key) {
        return this.definitionReader.getLatestVersionToKey(type, key);
    }

    public Optional<DefinitionResponseDto> getDefinitionWithAvailableTenants(DefinitionType type, String key, String userId) {
        return this.definitionReader.getDefinitionWithAvailableTenants(type, key).map(definitionWithTenantIdsDto -> {
            Optional<DefinitionResponseDto> authorizedDefinition = this.filterAndMapDefinitionsWithTenantIdsByAuthorizations(userId, Collections.singleton(definitionWithTenantIdsDto)).findFirst();
            return authorizedDefinition.orElseThrow(() -> new ForbiddenException(String.format("User [%s] is not authorized to definition with type [%s] and key [%s].", userId, type, key)));
        });
    }

    public List<DefinitionWithTenantIdsDto> getAllDefinitionsWithTenants(DefinitionType type) {
        return this.definitionReader.getFullyImportedDefinitionsWithTenantIds(type, Collections.emptySet(), Collections.emptySet());
    }

    public Optional<DefinitionWithTenantIdsDto> getProcessDefinitionWithTenants(String processDefinitionKey) {
        return this.definitionReader.getDefinitionWithAvailableTenants(DefinitionType.PROCESS, processDefinitionKey);
    }

    public List<DefinitionVersionResponseDto> getDefinitionVersions(DefinitionType type, String key, String userId) {
        return this.getDefinitionVersions(type, key, userId, null);
    }

    public List<DefinitionVersionResponseDto> getDefinitionVersions(DefinitionType type, String key, String userId, List<String> tenantIds) {
        ArrayList<DefinitionVersionResponseDto> definitionVersions = new ArrayList<DefinitionVersionResponseDto>();
        Optional<DefinitionResponseDto> optionalDefinition = this.getDefinitionWithAvailableTenants(type, key, userId);
        if (optionalDefinition.isPresent()) {
            List<String> availableTenants = optionalDefinition.get().getTenants().stream().map(TenantDto::getId).toList();
            HashSet tenantsToFilterFor = CollectionUtils.isEmpty(tenantIds) ? Sets.newHashSet(availableTenants) : availableTenants.stream().filter(tenantIds::contains).collect(Collectors.toSet());
            tenantsToFilterFor.add(null);
            definitionVersions.addAll(this.definitionReader.getDefinitionVersions(type, key, tenantsToFilterFor));
        }
        return definitionVersions;
    }

    public List<DefinitionVersionResponseDto> getDefinitionVersions(DefinitionType type, String key, List<String> tenantIds) {
        HashSet tenantsToFilterFor = Sets.newHashSet(tenantIds);
        tenantsToFilterFor.add(null);
        return this.definitionReader.getDefinitionVersions(type, key, tenantsToFilterFor);
    }

    public List<TenantDto> getDefinitionTenants(DefinitionType type, String key, String userId, List<String> versions) {
        return this.getDefinitionTenants(type, key, userId, versions, () -> this.getLatestVersionToKey(type, key));
    }

    public List<TenantDto> getDefinitionTenants(DefinitionType type, String key, String userId, List<String> versions, Supplier<String> latestVersionSupplier) {
        return this.definitionReader.getDefinitionWithAvailableTenants(type, key, versions, latestVersionSupplier).map(definitionWithTenantIdsDto -> {
            List<TenantDto> authorizedTenants = this.definitionAuthorizationService.resolveAuthorizedTenantsForProcess(userId, (SimpleDefinitionDto)definitionWithTenantIdsDto, definitionWithTenantIdsDto.getTenantIds(), definitionWithTenantIdsDto.getEngines());
            if (authorizedTenants.isEmpty()) {
                throw new ForbiddenException(String.format("User [%s] is either not authorized to the definition with type [%s] and key [%s] or is not authorized to access any of the tenants this definition  belongs to", userId, type, key));
            }
            return authorizedTenants;
        }).orElse(List.of());
    }

    public List<DefinitionResponseDto> getFullyImportedDefinitions(String userId) {
        if (userId == null) {
            throw new ForbiddenException("userId is null");
        }
        return this.getFullyImportedDefinitions(null, null, null, userId);
    }

    public List<DefinitionResponseDto> getFullyImportedDefinitions(DefinitionType definitionType, String userId) {
        if (userId == null) {
            throw new ForbiddenException("userId is null");
        }
        return this.getFullyImportedDefinitions(definitionType, null, null, userId);
    }

    public List<DefinitionResponseDto> getFullyImportedDefinitions(DefinitionType definitionType, Set<String> keys, List<String> tenantIds, String userId) {
        if (userId == null) {
            throw new ForbiddenException("userId is null");
        }
        HashSet<String> tenantsToFilterFor = this.resolveTenantsToFilterFor(tenantIds, userId);
        List<DefinitionWithTenantIdsDto> fullyImportedDefinitions = this.definitionReader.getFullyImportedDefinitionsWithTenantIds(definitionType, keys, tenantsToFilterFor);
        return this.filterAndMapDefinitionsWithTenantIdsByAuthorizations(userId, fullyImportedDefinitions).sorted(Comparator.comparing(a -> a.getName() == null ? a.getKey().toLowerCase(Locale.ENGLISH) : a.getName().toLowerCase(Locale.ENGLISH))).toList();
    }

    public <T extends DefinitionOptimizeResponseDto> Optional<T> getDefinition(DefinitionType type, String definitionKey, List<String> definitionVersions, List<String> tenantIds) {
        return DefinitionVersionHandlingUtil.isDefinitionVersionSetToAllOrLatest(definitionVersions) ? this.getLatestCachedDefinition(type, definitionKey, tenantIds) : this.definitionReader.getFirstFullyImportedDefinitionFromTenantsIfAvailable(type, definitionKey, definitionVersions, DefinitionService.prepareTenantListForDefinitionSearch(tenantIds));
    }

    public <T extends DefinitionOptimizeResponseDto> List<T> getFullyImportedDefinitions(DefinitionType type, String userId, boolean withXml) {
        LOG.debug("Fetching definitions of type " + String.valueOf(type));
        List definitionsResult = this.definitionReader.getFullyImportedDefinitions(type, withXml);
        if (userId != null) {
            definitionsResult = this.filterAuthorizedDefinitions(userId, definitionsResult);
        }
        return definitionsResult;
    }

    public List<TenantWithDefinitionsResponseDto> getDefinitionsGroupedByTenant(String userId) {
        Map<String, TenantIdWithDefinitionsDto> definitionsGroupedByTenant = this.definitionReader.getDefinitionsGroupedByTenant();
        Map<String, TenantDto> authorizedTenantDtosById = this.getAuthorizedTenantDtosForUser(userId);
        this.addSharedDefinitionsToAllAuthorizedTenantEntries(definitionsGroupedByTenant, authorizedTenantDtosById.keySet());
        return definitionsGroupedByTenant.values().stream().map(tenantIdWithDefinitionsDto -> Pair.of((Object)tenantIdWithDefinitionsDto, (Object)((TenantDto)authorizedTenantDtosById.get(tenantIdWithDefinitionsDto.getId())))).filter(tenantIdWithDefinitionsDtoTenantDtoPair -> tenantIdWithDefinitionsDtoTenantDtoPair.getRight() != null).map(tenantIdWithDefinitionsDtoTenantDtoPair -> {
            TenantIdWithDefinitionsDto tenantIdWithDefinitionsDto = (TenantIdWithDefinitionsDto)tenantIdWithDefinitionsDtoTenantDtoPair.getLeft();
            TenantDto tenantDto = (TenantDto)tenantIdWithDefinitionsDtoTenantDtoPair.getRight();
            String tenantId = tenantIdWithDefinitionsDto.getId();
            List<SimpleDefinitionDto> authorizedDefinitions = tenantIdWithDefinitionsDto.getDefinitions().stream().filter(definition -> this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, tenantId, (SimpleDefinitionDto)definition)).sorted(Comparator.comparing(a -> a.getName() == null ? a.getKey().toLowerCase(Locale.ENGLISH) : a.getName().toLowerCase(Locale.ENGLISH))).toList();
            return new TenantWithDefinitionsResponseDto(tenantDto.getId(), tenantDto.getName(), authorizedDefinitions);
        }).filter(tenantWithDefinitionsDto -> !tenantWithDefinitionsDto.getDefinitions().isEmpty()).sorted(Comparator.comparing(TenantWithDefinitionsResponseDto::getId, Comparator.nullsFirst(Comparator.naturalOrder()))).toList();
    }

    public <T extends DefinitionOptimizeResponseDto> Optional<T> getDefinitionWithXml(DefinitionType type, String userId, String definitionKey, String version, String tenantId) {
        return this.getDefinitionWithXml(type, userId, definitionKey, Collections.singletonList(version), Collections.singletonList(tenantId));
    }

    public <T extends DefinitionOptimizeResponseDto> Optional<T> getDefinitionWithXml(DefinitionType type, String userId, String definitionKey, List<String> definitionVersions, List<String> tenantIds) {
        return this.getDefinitionWithXmlAsService(type, definitionKey, definitionVersions, tenantIds).map(definitionOptimizeDto -> {
            if (this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, definitionOptimizeDto)) {
                return definitionOptimizeDto;
            }
            throw new ForbiddenException("Current user is not authorized to access data of the definition with key " + definitionKey);
        });
    }

    public <T extends DefinitionOptimizeResponseDto> Optional<T> getProcessDefinitionWithXmlAsService(DefinitionType type, String definitionKey, String definitionVersion, String tenantId) {
        return this.getDefinitionWithXmlAsService(type, definitionKey, Collections.singletonList(definitionVersion), Optional.ofNullable(tenantId).map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    public <T extends DefinitionOptimizeResponseDto> Optional<T> getDefinitionWithXmlAsService(DefinitionType type, String definitionKey, List<String> definitionVersions, List<String> tenantIds) {
        if (definitionKey == null || definitionVersions == null || definitionVersions.isEmpty()) {
            return Optional.empty();
        }
        return this.getDefinition(type, definitionKey, definitionVersions, tenantIds);
    }

    public static List<String> prepareTenantListForDefinitionSearch(List<String> selectedTenantIds) {
        ArrayList<String> tenantIdsForDefinitionSearch = new ArrayList<String>(selectedTenantIds);
        tenantIdsForDefinitionSearch.add(null);
        return tenantIdsForDefinitionSearch.stream().distinct().sorted(selectedTenantIds.size() == 1 ? Comparator.nullsLast(Comparator.naturalOrder()) : Comparator.nullsFirst(Comparator.naturalOrder())).toList();
    }

    public Map<String, String> extractFlowNodeIdAndNames(List<ProcessDefinitionOptimizeDto> definitions) {
        return definitions.stream().map(ProcessDefinitionOptimizeDto::getFlowNodeData).map(BpmnModelUtil::extractFlowNodeNames).map(Map::entrySet).flatMap(Collection::stream).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (String)entry.getValue()), HashMap::putAll);
    }

    public Map<String, String> extractUserTaskIdAndNames(List<ProcessDefinitionOptimizeDto> definitions) {
        return definitions.stream().map(ProcessDefinitionOptimizeDto::getUserTaskNames).map(Map::entrySet).flatMap(Collection::stream).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (String)entry.getValue()), HashMap::putAll);
    }

    public Map<String, String> fetchDefinitionFlowNodeNamesAndIdsForProcessInstances(List<ProcessInstanceDto> processInstanceDtos) {
        return this.extractFlowNodeIdAndNames(processInstanceDtos.stream().map(processInstanceDto -> Pair.of((Object)processInstanceDto.getProcessDefinitionKey(), (Object)processInstanceDto.getProcessDefinitionVersion())).distinct().map(processDefinition -> this.getDefinition(DefinitionType.PROCESS, (String)processDefinition.getLeft(), List.of((String)processDefinition.getRight()), Collections.emptyList())).filter(Optional::isPresent).map(Optional::get).map(ProcessDefinitionOptimizeDto.class::cast).collect(Collectors.toList()));
    }

    public Optional<DefinitionOptimizeResponseDto> getLatestCachedDefinitionOnAnyTenant(DefinitionType type, String definitionKey) {
        try {
            Comparator<Map.Entry> defVersionComparator = Comparator.comparingInt(e -> Integer.parseInt(((DefinitionOptimizeResponseDto)e.getValue()).getVersion()));
            return this.getCachedTenantToLatestDefinitionMap(type, definitionKey).entrySet().stream().sorted(defVersionComparator.reversed()).map(Map.Entry::getValue).findFirst();
        }
        catch (NumberFormatException exception) {
            throw new OptimizeRuntimeException("Error parsing version string for sorting definitions");
        }
    }

    private Map<String, DefinitionOptimizeResponseDto> fetchLatestProcessDefinition(String definitionKey) {
        return this.fetchLatestDefinition(DefinitionType.PROCESS, definitionKey);
    }

    private Map<String, DefinitionOptimizeResponseDto> fetchLatestDecisionDefinition(String definitionKey) {
        return this.fetchLatestDefinition(DefinitionType.DECISION, definitionKey);
    }

    private Map<String, DefinitionOptimizeResponseDto> fetchLatestDefinition(DefinitionType type, String definitionKey) {
        List definitions = this.definitionReader.getLatestFullyImportedDefinitionsFromTenantsIfAvailable(type, definitionKey);
        return definitions.stream().collect(Collectors.toMap(DefinitionOptimizeResponseDto::getTenantId, Function.identity()));
    }

    private Optional<DefinitionOptimizeResponseDto> getLatestCachedDefinition(DefinitionType type, String definitionKey, List<String> tenantIds) {
        List<Map.Entry> sortedFilteredEntries;
        Map<String, DefinitionOptimizeResponseDto> tenantToDefinitionMap = this.getCachedTenantToLatestDefinitionMap(type, definitionKey);
        try {
            sortedFilteredEntries = tenantToDefinitionMap.entrySet().stream().filter(e -> tenantIds.contains(e.getKey()) || e.getKey() == null).sorted(Comparator.comparing(e -> Integer.parseInt(((DefinitionOptimizeResponseDto)e.getValue()).getVersion()))).toList();
        }
        catch (NumberFormatException exception) {
            throw new OptimizeRuntimeException("Error while parsing versions while trying to sort definitions");
        }
        if (sortedFilteredEntries.size() <= 1) {
            return Optional.ofNullable(sortedFilteredEntries.isEmpty() ? null : (DefinitionOptimizeResponseDto)sortedFilteredEntries.get(0).getValue());
        }
        DefinitionService.prepareTenantListForDefinitionSearch(tenantIds);
        return sortedFilteredEntries.stream().filter(e -> tenantIds.contains(e.getKey())).map(Map.Entry::getValue).findFirst();
    }

    public boolean definitionExists(DefinitionType type, String definitionKey) {
        return !this.getCachedTenantToLatestDefinitionMap(type, definitionKey).isEmpty();
    }

    public Map<String, DefinitionOptimizeResponseDto> getCachedTenantToLatestDefinitionMap(DefinitionType type, String definitionKey) {
        if (DefinitionType.PROCESS.equals((Object)type)) {
            return (Map)this.latestProcessDefinitionCache.get((Object)definitionKey);
        }
        return (Map)this.latestDecisionDefinitionCache.get((Object)definitionKey);
    }

    private HashSet<String> resolveTenantsToFilterFor(List<String> tenantIds, String userId) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        return Sets.newHashSet((Iterable)Optional.ofNullable(tenantIds).map(ids -> this.filterAuthorizedTenants(userId, (List<String>)ids)).map(DefinitionService::prepareTenantListForDefinitionSearch).orElseGet(() -> this.tenantService.getTenantIdsForUser(userId)));
    }

    private List<String> filterAuthorizedTenants(String userId, List<String> tenantIds) {
        return tenantIds.stream().filter(tenantId -> this.tenantService.isAuthorizedToSeeTenant(userId, (String)tenantId)).toList();
    }

    private void addSharedDefinitionsToAllAuthorizedTenantEntries(Map<String, TenantIdWithDefinitionsDto> definitionsGroupedByTenant, Set<String> authorizedTenantIds) {
        TenantIdWithDefinitionsDto notDefinedTenantEntry = definitionsGroupedByTenant.get(TENANT_NOT_DEFINED.getId());
        if (notDefinedTenantEntry != null) {
            authorizedTenantIds.forEach(authorizedTenantId -> definitionsGroupedByTenant.compute((String)authorizedTenantId, (tenantId, tenantIdWithDefinitionsDto) -> {
                if (tenantIdWithDefinitionsDto == null) {
                    tenantIdWithDefinitionsDto = new TenantIdWithDefinitionsDto((String)tenantId, (List<SimpleDefinitionDto>)new ArrayList<SimpleDefinitionDto>());
                }
                List<SimpleDefinitionDto> mergedDefinitionList = DefinitionService.mergeTwoCollectionsWithDistinctValues(tenantIdWithDefinitionsDto.getDefinitions(), notDefinedTenantEntry.getDefinitions());
                tenantIdWithDefinitionsDto.setDefinitions(mergedDefinitionList);
                return tenantIdWithDefinitionsDto;
            }));
        }
    }

    private Stream<DefinitionResponseDto> filterAndMapDefinitionsWithTenantIdsByAuthorizations(String userId, Collection<DefinitionWithTenantIdsDto> definitionsWithTenantIds) {
        return definitionsWithTenantIds.stream().map(definitionWithTenantIdsDto -> DefinitionResponseDto.from(definitionWithTenantIdsDto, this.definitionAuthorizationService.resolveAuthorizedTenantsForProcess(userId, (SimpleDefinitionDto)definitionWithTenantIdsDto, definitionWithTenantIdsDto.getTenantIds(), definitionWithTenantIdsDto.getEngines()))).filter(definitionWithTenantsDto -> !definitionWithTenantsDto.getTenants().isEmpty());
    }

    private Map<String, TenantDto> getAuthorizedTenantDtosForUser(String userId) {
        return this.tenantService.getTenantsForUser(userId).stream().collect(Collectors.toMap(TenantDto::getId, Function.identity()));
    }

    private <T extends DefinitionOptimizeResponseDto> List<T> filterAuthorizedDefinitions(String userId, List<T> definitions) {
        return definitions.stream().filter(definition -> this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, definition)).collect(Collectors.toList());
    }

    private static <T> List<T> mergeTwoCollectionsWithDistinctValues(Collection<T> firstCollection, Collection<T> secondCollection) {
        return Stream.concat(secondCollection.stream(), firstCollection.stream()).distinct().toList();
    }
}

