/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisRequestDto;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisResponseDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.db.reader.BranchAnalysisReader;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import io.camunda.optimize.service.util.ValidationHelper;
import java.time.ZoneId;
import org.springframework.stereotype.Component;

@Component
public class BranchAnalysisService {
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final BranchAnalysisReader branchAnalysisReader;

    public BranchAnalysisService(DataSourceDefinitionAuthorizationService definitionAuthorizationService, BranchAnalysisReader branchAnalysisReader) {
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.branchAnalysisReader = branchAnalysisReader;
    }

    public BranchAnalysisResponseDto branchAnalysis(String userId, BranchAnalysisRequestDto request, ZoneId timezone) {
        ValidationHelper.validate(request);
        if (!this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, DefinitionType.PROCESS, request.getProcessDefinitionKey(), request.getTenantIds())) {
            throw new ForbiddenException("Current user is not authorized to access data of the provided process definition and tenant combination");
        }
        return this.branchAnalysisReader.branchAnalysis(request, timezone);
    }
}

