/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.optimize.dto.optimize.BackupState;
import io.camunda.optimize.dto.optimize.rest.BackupInfoDto;
import io.camunda.optimize.dto.optimize.rest.SnapshotInfoDto;
import io.camunda.optimize.dto.optimize.rest.SnapshotState;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.reader.BackupReader;
import io.camunda.optimize.service.db.writer.BackupWriter;
import io.camunda.optimize.service.exceptions.conflict.OptimizeConflictException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackupService {
    private static final int EXPECTED_NUMBER_OF_SNAPSHOTS_PER_BACKUP = 2;
    private static final Logger LOG = LoggerFactory.getLogger(BackupService.class);
    private final BackupReader backupReader;
    private final BackupWriter backupWriter;
    private final ConfigurationService configurationService;

    public BackupService(BackupReader backupReader, BackupWriter backupWriter, ConfigurationService configurationService) {
        this.backupReader = backupReader;
        this.backupWriter = backupWriter;
        this.configurationService = configurationService;
    }

    public synchronized void triggerBackup(Long backupId) {
        this.backupReader.validateRepositoryExists();
        this.validateNoDuplicateBackupId(backupId);
        LOG.info("Triggering backup with ID {}", (Object)backupId);
        this.backupWriter.triggerSnapshotCreation(backupId);
    }

    public List<BackupInfoDto> getAllBackupInfo() {
        this.backupReader.validateRepositoryExists();
        return this.backupReader.getAllOptimizeSnapshotsByBackupId().entrySet().stream().map(entry -> this.getSingleBackupInfo((Long)entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.groupingBy(SnapshotInfoDto::getState)))).toList();
    }

    public BackupInfoDto getSingleBackupInfo(Long backupId) {
        this.backupReader.validateRepositoryExists();
        return this.getSingleBackupInfo(backupId, this.backupReader.getOptimizeSnapshotsForBackupId(backupId).stream().collect(Collectors.groupingBy(SnapshotInfoDto::getState)));
    }

    private BackupInfoDto getSingleBackupInfo(Long backupId, Map<SnapshotState, List<SnapshotInfoDto>> snapshotInfosPerState) {
        if (snapshotInfosPerState.isEmpty()) {
            String reason = String.format("No Optimize backup with ID [%d] could be found.", backupId);
            LOG.error(reason);
            throw new NotFoundException(reason);
        }
        return this.getBackupInfoDto(backupId, snapshotInfosPerState);
    }

    private BackupInfoDto getBackupInfoDto(Long backupId, Map<SnapshotState, List<SnapshotInfoDto>> snapshotInfosPerState) {
        BackupState backupState = this.determineBackupState(snapshotInfosPerState);
        String failureReason = null;
        if (BackupState.FAILED == backupState) {
            failureReason = String.format("The following snapshots failed: [%s]", snapshotInfosPerState.getOrDefault(SnapshotState.FAILED, Collections.emptyList()).stream().map(SnapshotInfoDto::getSnapshotName).collect(Collectors.joining(", ")));
        }
        return new BackupInfoDto(backupId.longValue(), failureReason, backupState, snapshotInfosPerState.values().stream().flatMap(Collection::stream).toList());
    }

    public void deleteBackup(Long backupId) {
        this.backupReader.validateRepositoryExists();
        this.backupWriter.deleteOptimizeSnapshots(backupId);
    }

    private BackupState determineBackupState(Map<SnapshotState, List<SnapshotInfoDto>> snapshotInfosPerState) {
        if (snapshotInfosPerState.getOrDefault(SnapshotState.SUCCESS, Collections.emptyList()).size() == 2) {
            return BackupState.COMPLETED;
        }
        if (snapshotInfosPerState.get(SnapshotState.FAILED) != null || snapshotInfosPerState.get(SnapshotState.PARTIAL) != null) {
            return BackupState.FAILED;
        }
        if (snapshotInfosPerState.get(SnapshotState.INCOMPATIBLE) != null) {
            return BackupState.INCOMPATIBLE;
        }
        if (snapshotInfosPerState.get(SnapshotState.IN_PROGRESS) != null) {
            return BackupState.IN_PROGRESS;
        }
        if (snapshotInfosPerState.getOrDefault(SnapshotState.SUCCESS, Collections.emptyList()).size() < 2) {
            return BackupState.INCOMPLETE;
        }
        return BackupState.FAILED;
    }

    private void validateNoDuplicateBackupId(Long backupId) {
        List<SnapshotInfoDto> existingSnapshots = this.backupReader.getOptimizeSnapshotsForBackupId(backupId);
        if (!existingSnapshots.isEmpty()) {
            String reason = String.format("A backup with ID [%s] already exists. Found snapshots: [%s]", backupId, existingSnapshots.stream().map(SnapshotInfoDto::getSnapshotName).collect(Collectors.joining(", ")));
            LOG.error(reason);
            throw new OptimizeConflictException(reason);
        }
    }
}

