/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.util;

import jakarta.servlet.http.HttpServletRequest;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeZoneUtil {
    private static final Set<String> AVAILABLE_ZONE_IDS = ZoneId.getAvailableZoneIds();
    private static final Logger LOG = LoggerFactory.getLogger(TimeZoneUtil.class);

    private TimeZoneUtil() {
    }

    public static ZoneId extractTimezone(HttpServletRequest request) {
        String headerString = request.getHeader("X-Optimize-Client-Timezone");
        if (AVAILABLE_ZONE_IDS.contains(headerString)) {
            return ZoneId.of(headerString);
        }
        if (headerString != null) {
            LOG.warn("The provided timezone [{}] was not recognized. Falling back to server timezone [{}] instead.", (Object)headerString, (Object)ZoneId.systemDefault().getId());
        }
        return ZoneId.systemDefault();
    }

    public static String formatToCorrectTimezone(String dateAsString, ZoneId timezone, DateTimeFormatter dateTimeFormatter) {
        OffsetDateTime date = OffsetDateTime.parse(dateAsString, dateTimeFormatter);
        OffsetDateTime dateWithAdjustedTimezone = date.atZoneSameInstant(timezone).toOffsetDateTime();
        return dateTimeFormatter.format(dateWithAdjustedTimezone);
    }

    public static String formatToCorrectTimezone(ZonedDateTime date, ZoneId timezone, DateTimeFormatter dateTimeFormatter) {
        return date.withZoneSameInstant(timezone).format(dateTimeFormatter);
    }
}

