/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security;

import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class AuthenticationCookieFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private final SessionService sessionService;

    public AuthenticationCookieFilter(SessionService sessionService, AuthenticationManager authenticationManager) {
        this.sessionService = sessionService;
        this.setAuthenticationManager(authenticationManager);
    }

    public AuthenticationCookieFilter(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        return this.getJwtAuthenticationToken(request).filter(this.sessionService::isValidToken).flatMap(AuthCookieService::getTokenSubject).orElse(null);
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return this.getJwtAuthenticationToken(request).orElse(null);
    }

    private Optional<String> getJwtAuthenticationToken(HttpServletRequest request) {
        return AuthCookieService.getAuthCookieToken(request);
    }
}

