/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import io.camunda.optimize.dto.optimize.query.ui_configuration.AppName;
import io.camunda.optimize.rest.cloud.AccountsUserAccessTokenProvider;
import io.camunda.optimize.rest.cloud.CCSaaSOrganizationsClient;
import io.camunda.optimize.rest.cloud.CCSaasClusterClient;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CloudSaasMetaInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(CloudSaasMetaInfoService.class);
    private final CCSaaSOrganizationsClient organizationsClient;
    private final AccountsUserAccessTokenProvider accessTokenProvider;
    private final CCSaasClusterClient clusterClient;

    public CloudSaasMetaInfoService(CCSaaSOrganizationsClient organizationsClient, AccountsUserAccessTokenProvider accessTokenProvider, CCSaasClusterClient clusterClient) {
        this.organizationsClient = organizationsClient;
        this.accessTokenProvider = accessTokenProvider;
        this.clusterClient = clusterClient;
    }

    public Optional<String> getSalesPlanType() {
        Optional<String> accessToken = this.getCurrentUserServiceToken();
        if (accessToken.isPresent()) {
            try {
                return this.organizationsClient.getSalesPlanType(accessToken.get());
            }
            catch (OptimizeRuntimeException e) {
                LOG.warn("Failed retrieving salesPlanType.", (Throwable)e);
                return Optional.empty();
            }
        }
        LOG.warn("No user access token found, will not retrieve salesPlanType");
        return Optional.empty();
    }

    public Map<AppName, String> getWebappsLinks() {
        Optional<String> accessToken = this.getCurrentUserServiceToken();
        if (accessToken.isPresent()) {
            try {
                return this.clusterClient.getWebappLinks(accessToken.get());
            }
            catch (OptimizeRuntimeException e) {
                LOG.warn("Failed retrieving webapp links  .", (Throwable)e);
                return Collections.emptyMap();
            }
        }
        LOG.warn("No user access token found, will not retrieve links to other webapps.");
        return Collections.emptyMap();
    }

    public Optional<String> getCurrentUserServiceToken() {
        return this.accessTokenProvider.getCurrentUsersAccessToken();
    }
}

