/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.cloud.CloudUserDto;
import io.camunda.optimize.rest.cloud.AbstractCCSaaSClient;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSUserClient
extends AbstractCCSaaSClient {
    private static final String GET_USER_BY_ID_TEMPLATE = "%s/external/organizations/%s/members/%s";
    private static final String GET_USERS_TEMPLATE = "%s/external/organizations/%s/members?filter=members";
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSUserClient.class);

    public CCSaaSUserClient(ConfigurationService configurationService, ObjectMapper objectMapper) {
        super(objectMapper, configurationService);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<CloudUserDto> getCloudUserById(String userId, String accessToken) {
        try {
            LOG.info("Fetching Cloud user by id.");
            HttpGet request = new HttpGet(String.format(GET_USER_BY_ID_TEMPLATE, this.getCloudUsersConfiguration().getAccountsUrl(), this.getCloudAuthConfiguration().getOrganizationId(), URLEncoder.encode(userId, StandardCharsets.UTF_8)));
            try (CloseableHttpResponse response = this.performRequest((HttpRequestBase)request, accessToken);){
                if (response.getStatusLine().getStatusCode() == HttpStatus.NOT_FOUND.value()) {
                    Optional<CloudUserDto> optional2 = Optional.empty();
                    return optional2;
                }
                if (response.getStatusLine().getStatusCode() != HttpStatus.OK.value()) {
                    throw new OptimizeRuntimeException(String.format("Unexpected response when fetching cloud user by id: %s", response.getStatusLine().getStatusCode()));
                }
                Optional<CloudUserDto> optional = Optional.ofNullable((CloudUserDto)this.objectMapper.readValue(response.getEntity().getContent(), CloudUserDto.class));
                return optional;
            }
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("There was a problem fetching the cloud user by id.", (Throwable)e);
        }
    }

    public List<CloudUserDto> fetchAllCloudUsers(String accessToken) {
        List list;
        block9: {
            LOG.info("Fetching Cloud users.");
            HttpGet request = new HttpGet(String.format(GET_USERS_TEMPLATE, this.getCloudUsersConfiguration().getAccountsUrl(), this.getCloudAuthConfiguration().getOrganizationId()));
            CloseableHttpResponse response = this.performRequest((HttpRequestBase)request, accessToken);
            try {
                if (response.getStatusLine().getStatusCode() != HttpStatus.OK.value()) {
                    throw new OptimizeRuntimeException(String.format("Unexpected response when fetching cloud users: %s", response.getStatusLine().getStatusCode()));
                }
                list = (List)this.objectMapper.readValue(response.getEntity().getContent(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, CloudUserDto.class));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OptimizeRuntimeException("There was a problem fetching Cloud users.", (Throwable)e);
                }
            }
            response.close();
        }
        return list;
    }
}

