/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.cloud.TokenRequestDto;
import io.camunda.optimize.dto.optimize.cloud.TokenResponseDto;
import io.camunda.optimize.rest.cloud.AbstractCCSaaSClient;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSM2MTokenProvider
extends AbstractCCSaaSClient {
    private static final String TOKEN_REQUEST_GRANT_TYPE = "client_credentials";
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSM2MTokenProvider.class);

    protected CCSaaSM2MTokenProvider(ObjectMapper objectMapper, ConfigurationService configurationService) {
        super(objectMapper, configurationService);
    }

    public TokenResponseDto retrieveM2MToken(String audience) {
        TokenResponseDto tokenResponseDto;
        block9: {
            TokenRequestDto tokenRequestDto = TokenRequestDto.builder().grantType(TOKEN_REQUEST_GRANT_TYPE).audience(audience).clientId(this.getM2MClientId()).clientSecret(this.getM2MClientSecret()).build();
            LOG.info("Requesting M2M token");
            HttpPost request = new HttpPost(this.getTokenProviderUrl());
            StringEntity notificationRequestBody = new StringEntity(this.objectMapper.writeValueAsString((Object)tokenRequestDto), ContentType.APPLICATION_JSON);
            request.setHeader("Content-Type", "application/json");
            request.setEntity((HttpEntity)notificationRequestBody);
            CloseableHttpResponse response = this.performRequest((HttpRequestBase)request);
            try {
                HttpStatus status = HttpStatus.resolve((int)response.getStatusLine().getStatusCode());
                if (!HttpStatus.OK.equals((Object)status)) {
                    throw new OptimizeRuntimeException("Unexpected response when retrieving M2M token: " + String.valueOf(status));
                }
                tokenResponseDto = (TokenResponseDto)this.objectMapper.readValue(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8), TokenResponseDto.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OptimizeRuntimeException("There was a problem retrieving the M2M token.", (Throwable)e);
                }
            }
            response.close();
        }
        return tokenResponseDto;
    }

    private String getTokenProviderUrl() {
        return this.configurationService.getAuthConfiguration().getCloudAuthConfiguration().getTokenUrl();
    }

    private String getM2MClientId() {
        return this.configurationService.getM2mAuth0ClientConfiguration().getM2mClientId();
    }

    private String getM2MClientSecret() {
        return this.configurationService.getM2mAuth0ClientConfiguration().getM2mClientSecret();
    }
}

