/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.rest.FlowNodeIdsToNamesRequestDto;
import io.camunda.optimize.dto.optimize.rest.FlowNodeNamesResponseDto;
import io.camunda.optimize.rest.providers.CacheRequest;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.util.BpmnModelUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/flow-node"})
public class FlowNodeRestService {
    public static final String FLOW_NODE_PATH = "/flow-node";
    public static final String FLOW_NODE_NAMES_SUB_PATH = "/flowNodeNames";
    private static final Logger LOG = LoggerFactory.getLogger(FlowNodeRestService.class);
    private final DefinitionService definitionService;

    public FlowNodeRestService(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }

    @PostMapping(value={"/flowNodeNames"})
    @CacheRequest
    public FlowNodeNamesResponseDto getFlowNodeNames(@RequestBody FlowNodeIdsToNamesRequestDto request) {
        FlowNodeNamesResponseDto result = new FlowNodeNamesResponseDto();
        Optional processDefinitionXmlDto = this.definitionService.getProcessDefinitionWithXmlAsService(DefinitionType.PROCESS, request.getProcessDefinitionKey(), request.getProcessDefinitionVersion(), request.getTenantId());
        if (processDefinitionXmlDto.isPresent()) {
            List<String> nodeIds = request.getNodeIds();
            Map<String, String> flowNodeIdsToNames = BpmnModelUtil.extractFlowNodeNames(((ProcessDefinitionOptimizeDto)processDefinitionXmlDto.get()).getFlowNodeData());
            if (nodeIds != null && !nodeIds.isEmpty()) {
                for (String id : nodeIds) {
                    result.getFlowNodeNames().put(id, flowNodeIdsToNames.get(id));
                }
            } else {
                result.setFlowNodeNames(flowNodeIdsToNames);
            }
        } else {
            LOG.debug("No process definition found for key {} and version {}, returning empty result.", (Object)request.getProcessDefinitionKey(), (Object)request.getProcessDefinitionVersion());
        }
        return result;
    }
}

