/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.entity.EntitiesDeleteRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameResponseDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityResponseDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.rest.sorting.EntitySorter;
import io.camunda.optimize.rest.mapper.EntityRestMapper;
import io.camunda.optimize.service.entities.EntitiesService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/entities"})
public class EntitiesRestService {
    public static final String ENTITIES_PATH = "/entities";
    private final EntitiesService entitiesService;
    private final SessionService sessionService;
    private final EntityRestMapper entityRestMapper;

    public EntitiesRestService(EntitiesService entitiesService, SessionService sessionService, EntityRestMapper entityRestMapper) {
        this.entitiesService = entitiesService;
        this.sessionService = sessionService;
        this.entityRestMapper = entityRestMapper;
    }

    @GetMapping
    public List<EntityResponseDto> getEntities(@RequestParam(name="sortBy", required=false) String sortBy, @RequestParam(name="sortOrder", required=false) SortOrder sortOrder, HttpServletRequest request) {
        EntitySorter entitySorter = new EntitySorter(sortBy, sortOrder);
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<EntityResponseDto> entities = this.entitiesService.getAllEntities(userId);
        entities.forEach(this.entityRestMapper::prepareRestResponse);
        return entitySorter.applySort(entities);
    }

    @GetMapping(value={"/names"})
    public EntityNameResponseDto getEntityNames(EntityNameRequestDto requestDto, HttpServletRequest request) {
        return this.entitiesService.getEntityNames(requestDto, request.getHeader("X-Optimize-Client-Locale"));
    }

    @PostMapping(value={"/delete-conflicts"})
    public boolean entitiesHaveDeleteConflicts(@Valid @NotNull @RequestBody EntitiesDeleteRequestDto entities, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.entitiesService.entitiesHaveConflicts(entities, userId);
    }

    @PostMapping(value={"/delete"})
    public void bulkDeleteEntities(@Valid @NotNull @RequestBody EntitiesDeleteRequestDto entities, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.entitiesService.bulkDeleteEntities(entities, userId);
    }
}

