/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.DecisionVariableValueRequestDto;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.variable.DecisionVariableService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/decision-variables"})
public class DecisionVariablesRestService {
    public static final String DECISION_VARIABLES_PATH = "/decision-variables";
    public static final String DECISION_INPUTS_NAMES_PATH = "/inputs/names";
    public static final String DECISION_OUTPUTS_NAMES_PATH = "/outputs/names";
    private final DecisionVariableService decisionVariableService;
    private final SessionService sessionService;

    public DecisionVariablesRestService(DecisionVariableService decisionVariableService, SessionService sessionService) {
        this.decisionVariableService = decisionVariableService;
        this.sessionService = sessionService;
    }

    @PostMapping(value={"/inputs/names"})
    public List<DecisionVariableNameResponseDto> getInputVariableNames(@Valid @RequestBody List<DecisionVariableNameRequestDto> variableRequestDto) {
        return this.decisionVariableService.getInputVariableNames(variableRequestDto);
    }

    @PostMapping(value={"/outputs/names"})
    public List<DecisionVariableNameResponseDto> getOutputVariableNames(@Valid @RequestBody List<DecisionVariableNameRequestDto> variableRequestDto) {
        return this.decisionVariableService.getOutputVariableNames(variableRequestDto);
    }

    @PostMapping(value={"/inputs/values"})
    public List<String> getInputValues(@RequestBody DecisionVariableValueRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.decisionVariableService.getInputVariableValues(userId, requestDto);
    }

    @PostMapping(value={"/outputs/values"})
    public List<String> getOutputValues(@RequestBody DecisionVariableValueRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.decisionVariableService.getOutputVariableValues(userId, requestDto);
    }
}

